package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterGoods;
import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.vo.WaterGoodsVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商品Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterGoodsMapper
{
    /**
     * 查询商品
     *
     * @param id 商品主键
     * @return 商品
     */
    public WaterGoods selectWaterGoodsById(Long id);

    WaterGoods selectWaterGoodsById1(Long id);

    WaterGoods selectGoodsIdByCarId(Long id);

    WaterGoods getPriceByID(Long id);

    /**
     * 查询商品列表
     *
     * @param waterGoods 商品
     * @return 商品集合
     */
    public List<WaterGoods> selectWaterGoodsList(WaterGoods waterGoods);

    List<WaterGoods> selectWaterGoodsList1();
    /**
     * 新增商品
     *
     * @param waterGoodsVo 商品
     * @return 结果
     */
    public int insertWaterGoods(WaterGoodsVo waterGoodsVo);

    /**
     * 修改商品
     *
     * @param waterGoodsVo 商品
     * @return 结果
     */
    public int updateWaterGoods(WaterGoodsVo waterGoodsVo);

    /**
     * 删除商品
     *
     * @param id 商品主键
     * @return 结果
     */
    public int deleteWaterGoodsById(Long id);

    /**
     * 批量删除商品
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterGoodsByIds(Long[] ids);

    /**
     * 删除商品图片
     *
     * @param id 商品主键
     * @return 结果
     */
    public int deleteWaterGoodsImgByGoodsId(Long id);

    /**
     * 批量删除商品图片
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterGoodsImgByGoodsIds(Long[] ids);

    /**
     * 删除商品关联规格
     *
     * @param id 商品主键
     * @return 结果
     */
    public int deleteWaterGoodsSpeByGoodsId(Long id);

    /**
     * 批量删除商品关联规格
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterGoodsSpeByGoodsIds(Long[] ids);

    /**
     * 批量新增图片
     * @param list
     */
    void batchInsertWaterGoodsImg(@Param("list") List<WaterGoodsImg> list);

    /**
     * 批量新增图片(修改)
     * @param list
     */
    void batchInsertWaterGoodsImgs(List<WaterGoodsImg> list);

    /**
     * 水票商品信息
     * @return
     */
    WaterGoods selectGoodsSp();
}
