package com.qianhe.system.mapper;

import java.util.List;
import com.qianhe.system.domain.CcbKey;

/**
 * 建行工作密钥Mapper接口
 * 
 * @author qianhe
 * @date 2024-04-26
 */
public interface CcbKeyMapper 
{
    /**
     * 查询建行工作密钥
     * 
     * @param key 建行工作密钥主键
     * @return 建行工作密钥
     */
    public CcbKey selectCcbKeyByKey(String key);

    /**
     * 查询建行工作密钥列表
     * 
     * @param ccbKey 建行工作密钥
     * @return 建行工作密钥集合
     */
    public List<CcbKey> selectCcbKeyList(CcbKey ccbKey);

    /**
     * 新增建行工作密钥
     * 
     * @param ccbKey 建行工作密钥
     * @return 结果
     */
    public int insertCcbKey(CcbKey ccbKey);

    /**
     * 修改建行工作密钥
     * 
     * @param ccbKey 建行工作密钥
     * @return 结果
     */
    public int updateCcbKey(CcbKey ccbKey);

    /**
     * 删除建行工作密钥
     * 
     * @param key 建行工作密钥主键
     * @return 结果
     */
    public int deleteCcbKeyByKey(String key);

    /**
     * 批量删除建行工作密钥
     * 
     * @param keys 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCcbKeyByKeys(String[] keys);

    int updateCcbKeySfgq();

}
