package com.qianhe.system.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 用户地址对象 water_user_address
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterUserAddress
{
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 用户id */
    private Long waterUserId;

    /** 详细地址 */
    private String userAddress;

    /** 省 */
    private String province;

    /** 市 */
    private String city;

    /** 区 */
    private String area;

    /** 收货人姓名 */
    private String name;

    /** 收货人手机号 */
    private Long phone;

    /** 是否默认地址（1是，0否） */
    private String isDefault;

    /** 经度 */
    private double lon;

    /** 纬度 */
    private double lat;

}
