package com.qianhe.system.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;
import java.util.List;

/**
 * 用户对象 water_user
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterUser
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 昵称 */
    @Excel(name = "昵称")
    private String nickName;

    /** 手机号 */
    @Excel(name = "手机号")
    private Long phoneNum;

    /** 站点名称 */
    private String stationName;

    /** 用户类型 */
    private String userType;

    /** 性别(1男0女) */
    @Excel(name = "性别", combo = {"男","女","未知"}, readConverterExp = "1=男,0=女,2=未知")
    private Long userGender;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 状态(1逻辑删除) */
    private String status;

    /** 微信小程序open_id */
    private String openId;

    //是否可以记账
    private String sfjz;

}
