package com.qianhe.system.domain;

import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 通知公告文本对象 water_text
 *
 * @author qianhe
 * @date 2023-11-23
 */
public class WaterText extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    private Long id;

    /** 标题（首页公告，用户协议，隐私政策，关于我们） */
    @Excel(name = "标题", readConverterExp = "首=页公告，用户协议，隐私政策，关于我们")
    private String title;

    /** 内容 */
    @Excel(name = "内容")
    private String content;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getTitle()
    {
        return title;
    }
    public void setContent(String content)
    {
        this.content = content;
    }

    public String getContent()
    {
        return content;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("content", getContent())
            .append("createTime", getCreateTime())
            .toString();
    }
}
