package com.qianhe.system.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 站点用户对象 water_station_user
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterStationUser
{
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 年龄 */
    @Excel(name = "年龄")
    private Long age;

    /** 性别 */
    @Excel(name = "性别")
    private Long gender;

    /** 手机号 */
    @Excel(name = "手机号")
    private Long phone;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idNum;

    /** 站点id */
    @Excel(name = "站点id")
    private Long stationId;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createUser;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /** 公众号用户openid */
    @Excel(name = "公众号用户openid")
    private String openId;
    //送水小程序openid
    private String wxOpenid;

    private String isOpen;

    private String stationName;

}
