package com.qianhe.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 站点区域范围对象 water_station_region
 *
 * @author qianhe
 * @date 2024-04-15
 */
public class WaterStationRegion extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long ID;

    /** 站点id */
    @Excel(name = "站点id")
    private Long stationId;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal lon;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal lat;

    /** 排序 */
    @Excel(name = "排序")
    private Integer px;

    /** 录入人 */
    @Excel(name = "录入人")
    private String LRR;

    /** 录入时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "录入时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date LRSJ;

    /** 修改人 */
    @Excel(name = "修改人")
    private String XGR;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date XGSJ;

    /** 备注 */
    @Excel(name = "备注")
    private String BZ;

    /** 预留1 */
    @Excel(name = "预留1")
    private String YL1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String YL2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String YL3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String YL4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String YL5;

    public void setID(Long ID)
    {
        this.ID = ID;
    }

    public Long getID()
    {
        return ID;
    }
    public void setStationId(Long stationId)
    {
        this.stationId = stationId;
    }

    public Long getStationId()
    {
        return stationId;
    }
    public void setLon(BigDecimal lon)
    {
        this.lon = lon;
    }

    public BigDecimal getLon()
    {
        return lon;
    }
    public void setLat(BigDecimal lat)
    {
        this.lat = lat;
    }

    public BigDecimal getLat()
    {
        return lat;
    }
    public void setPx(Integer px)
    {
        this.px = px;
    }

    public Integer getPx()
    {
        return px;
    }
    public void setLRR(String LRR)
    {
        this.LRR = LRR;
    }

    public String getLRR()
    {
        return LRR;
    }
    public void setLRSJ(Date LRSJ)
    {
        this.LRSJ = LRSJ;
    }

    public Date getLRSJ()
    {
        return LRSJ;
    }
    public void setXGR(String XGR)
    {
        this.XGR = XGR;
    }

    public String getXGR()
    {
        return XGR;
    }
    public void setXGSJ(Date XGSJ)
    {
        this.XGSJ = XGSJ;
    }

    public Date getXGSJ()
    {
        return XGSJ;
    }
    public void setBZ(String BZ)
    {
        this.BZ = BZ;
    }

    public String getBZ()
    {
        return BZ;
    }
    public void setYL1(String YL1)
    {
        this.YL1 = YL1;
    }

    public String getYL1()
    {
        return YL1;
    }
    public void setYL2(String YL2)
    {
        this.YL2 = YL2;
    }

    public String getYL2()
    {
        return YL2;
    }
    public void setYL3(String YL3)
    {
        this.YL3 = YL3;
    }

    public String getYL3()
    {
        return YL3;
    }
    public void setYL4(String YL4)
    {
        this.YL4 = YL4;
    }

    public String getYL4()
    {
        return YL4;
    }
    public void setYL5(String YL5)
    {
        this.YL5 = YL5;
    }

    public String getYL5()
    {
        return YL5;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("ID", getID())
            .append("stationId", getStationId())
            .append("lon", getLon())
            .append("lat", getLat())
            .append("px", getPx())
            .append("LRR", getLRR())
            .append("LRSJ", getLRSJ())
            .append("XGR", getXGR())
            .append("XGSJ", getXGSJ())
            .append("BZ", getBZ())
            .append("YL1", getYL1())
            .append("YL2", getYL2())
            .append("YL3", getYL3())
            .append("YL4", getYL4())
            .append("YL5", getYL5())
            .toString();
    }
}
