package com.qianhe.system.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 站点对象 water_station
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterStation
{
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 站点名称 */
    @Excel(name = "站点名称")
    private String stationName;

    /** 电话 */
    @Excel(name = "电话")
    private Long phoneNum;

    /** 详细地址 */
    @Excel(name = "详细地址")
    private String stationAddress;

    /** 经度 */
    @Excel(name = "经度")
    private double stationLon;

    /** 纬度 */
    @Excel(name = "纬度")
    private double stationLat;


    /**高德转腾讯经度**/
    private double stationLonTen;
    /**高德转腾讯纬度**/
    private double stationLatTen;
    /** 省份 */
    @Excel(name = "省份")
    private String province;

    /** 城市 */
    @Excel(name = "城市")
    private String city;

    /** 市区 */
    @Excel(name = "市区")
    private String area;

    /** 是否打烊(1营业0打烊) */
    @Excel(name = "是否打烊(1营业0打烊)")
    private String isOpen;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createUser;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    //区域范围集合
    private List<WaterStationRegion> waterStationRegionList =new ArrayList<>();
}
