package com.qianhe.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单日志对象 water_order_log
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterOrderLog extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 付款时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "付款时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date payTime;

    /** 付款金额 */
    @Excel(name = "付款金额")
    private BigDecimal payMoney;

    /** 银行返回code */
    @Excel(name = "银行返回code")
    private String payNum;

    /** 退款时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "退款时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date payBackTime;

    /** 退款金额 */
    @Excel(name = "退款金额")
    private Long payBackMoney;

    /** 订单id */
    @Excel(name = "订单id")
    private Long orderId;

    private String bz;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setPayTime(Date payTime)
    {
        this.payTime = payTime;
    }

    public Date getPayTime()
    {
        return payTime;
    }
    public void setPayMoney(BigDecimal payMoney)
    {
        this.payMoney = payMoney;
    }

    public BigDecimal getPayMoney()
    {
        return payMoney;
    }
    public void setPayNum(String payNum)
    {
        this.payNum = payNum;
    }

    public String getPayNum()
    {
        return payNum;
    }
    public void setPayBackTime(Date payBackTime)
    {
        this.payBackTime = payBackTime;
    }

    public Date getPayBackTime()
    {
        return payBackTime;
    }
    public void setPayBackMoney(Long payBackMoney)
    {
        this.payBackMoney = payBackMoney;
    }

    public Long getPayBackMoney()
    {
        return payBackMoney;
    }
    public void setOrderId(Long orderId)
    {
        this.orderId = orderId;
    }

    public Long getOrderId()
    {
        return orderId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("payTime", getPayTime())
            .append("payMoney", getPayMoney())
            .append("payNum", getPayNum())
            .append("payBackTime", getPayBackTime())
            .append("payBackMoney", getPayBackMoney())
            .append("createTime", getCreateTime())
            .append("orderId", getOrderId())
            .toString();
    }
}
