package com.qianhe.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 订单商品对象 water_order_goods
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterOrderGoods
{
    private static final long serialVersionUID = 1L;

    private Long id;

    /** 订单id */
    private Long orderId;

    /** 订单编号 */
    private String orderNum;

    /** 商品分类id */
    private Long goodsTypeId;

    /** 商品分类 */
    private String goodsType;

    /** 规格详情 */
    private String goodsSpe;

    //规格数量
    private String speVal;

    /** 商品id */
    private Long goodsId;

    /** 商品名称 */
    @Excel(name = "产品名称")
    private String goodsTitle;
    /** 商品单价 */
    @Excel(name = "售价")
    private BigDecimal goodsPrice;

    /** 商品数量 */
    @Excel(name = "数量")
    private BigDecimal goodsNum;

    /** 商品总价 */
    @Excel(name = "金额")
    private BigDecimal goodsTotal;

    /** 备注 */
    private String remark;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    /** 创建人 */
    private String createUser;

    /** 封面图集合 */
    private List<WaterGoodsImg> coverImgs;

    /** 详情图集合 */
    private List<WaterGoodsImg> detailsImgs;
}
