package com.qianhe.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单对象 water_order
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterOrder extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    private Long id;

    /** 订单编号(生成规则当前年月日+当天下单0001开始+随机生成4位英文字母) */
    @Excel(name = "订单编号(生成规则当前年月日+当天下单0001开始+随机生成4位英文字母)")
    private String orderNum;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 用户名字 */
    @Excel(name = "用户名字")
    private String userName;

    /** 用户手机号 */
    @Excel(name = "用户手机号")
    private Long userPhone;

    /** 用户省 */
    @Excel(name = "用户省")
    private String userProvince;

    /** 用户城市 */
    @Excel(name = "用户城市")
    private String userCity;

    /** 用户区 */
    @Excel(name = "用户区")
    private String userArea;

    /** 用户详细地址 */
    @Excel(name = "用户详细地址")
    private String userAddress;

    /** 站点id */
    @Excel(name = "站点id")
    private Long stationId;

    /** 站点名字 */
    @Excel(name = "站点名字")
    private String stationName;

    /** 站点手机号 */
    @Excel(name = "站点手机号")
    private Long stationPhone;

    /** 站点省份 */
    @Excel(name = "站点省份")
    private String stationProvince;

    /** 站点城市 */
    @Excel(name = "站点城市")
    private String stationCity;

    /** 站点市区 */
    @Excel(name = "站点市区")
    private String stationArea;

    /** 站点详细地址 */
    @Excel(name = "站点详细地址")
    private String stationAddress;

    /** 订单商品分类（1商品页，2购物车） */
    private Integer orderGoodsType;

    /** 订单状态(1待付款2待接单3进行中4已完成5已取消6已退款) */
    @Excel(name = "订单状态(1待付款2待接单3进行中4已完成5已取消6已退款)")
    private Integer orderState;

    /** 送水工完成状态（0未完成，1已完成，2已退款） */
    private Integer completeState;

    /** 用户确认状态（0未确认，1确认收货，2确认退款） */
    private Integer confirmState;

    /** 付款状态(0未付款1已付款) */
    @Excel(name = "付款状态(0未付款1已付款)")
    private Integer payState;

    /** 支付方式(1银行2水票) */
    @Excel(name = "支付方式(1银行2水票)")
    private Integer payType;

    /** 银行返回支付成功code */
    @Excel(name = "银行返回支付成功code")
    private String payNum;

    /** 取消原因 */
    private String cancelResult;

    /** 用户地址id */
    private Long userAddressId;

    /** 收货人名字 */
    @Excel(name = "收货人名字")
    private String name;

    /** 省 */
    @Excel(name = "省")
    private String province;

    /** 市 */
    @Excel(name = "市")
    private String city;

    /** 区 */
    @Excel(name = "区")
    private String area;

    /** 详细地址 */
    @Excel(name = "详细地址")
    private String address;

    /** 收货地址经度 */
    private double lon;

    /** 收货地址纬度 */
    private double lat;

    /** 收货人手机号 */
    @Excel(name = "收货人手机号")
    private Long mobile;

    /** 送货时间 */
    @Excel(name = "送货时间")
    private String delieverTime;

    /** 送水工名字 */
    @Excel(name = "送水工名字")
    private String delieverName;

    /** 送水工电话 */
    @Excel(name = "送水工电话")
    private String delieverMobile;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createUser;

    /** 送达时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "送达时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date delieverOver;

    /** 收货时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "收货时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date takeTime;

    /** 完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date finishTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 商品总价 */
    @Excel(name = "商品总价")
    private BigDecimal goodsVal;

    /** 订单类型（1普通订单2退款订单） */
    @Excel(name = "订单类型", readConverterExp = "1=普通订单2退款订单")
    private Integer orderType;

    /** 退款原因 */
    private String returnOrderResult;
    /** 下单时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "下单时间",  dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date xdsj;

    //退款编号
    private String tkbh;

    private String authCode;
    private String wctype;


}
