package com.qianhe.system.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品关联规格对象 water_goods_spe
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterGoodsSpe
{
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 商品规格主键id */
    private Long waterSpeId;

    /** 标题 */
    @Excel(name = "标题")
    private String speTitle;

    /** 商品id */
    @Excel(name = "商品id")
    private Long goodsId;

    /** 创建人 */
    private String  createUser;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 价格 */
    private BigDecimal price;
}
