package com.qianhe.system.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 商品图片对象 water_goods_img
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterGoodsImg
{
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 图片名称 */
    private String imgName;

    /** 类型 */
    private String type;

    /** 大小 */
    private String sizea;

    /** 路径 */
    private String url;


    private String md5;

    /** 图片类型（1商品封面图2商品详情图3主页轮播图） */
    @Excel(name = "图片类型", readConverterExp = "1=商品封面图,2=商品详情图,3=主页轮播图")
    private Integer imgType;

    /** 商品id */
    @Excel(name = "商品id")
    private Long goodsId;
}
