package com.qianhe.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class WaterGoodsCart {

    /** 主键id */
    private Long id;

    /** 用户id */
    private Long userId;

    /** 商品id */
    private Long goodsId;

    /** 商品名称 */
    private String goodsName;

    /** 商品分类id */
    private Long goodsTypeId;

    /** 商品分类名称 */
    private String goodsTypeName;

    /** 商品规格id */
    private String goodsSpeId;

    /** 商品规格值id */
    private String goodsSpeValId;

    /** 商品规格详情 */
    private String goodsSpeVal;

    /** 商品价格 */
    private BigDecimal goodsPrice;

    /** 商品数量 */
    private Integer goodsNum;

    /** 商品总价 */
    private BigDecimal goodsTotal;

    /** 是否选中(1是，0否) */
    private String isSelect;

    /** 上架状态 */
    private String status;

    /** 创建人 */
    private String createUser;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    private String openId;

    /** 封面图集合 */
    private List<WaterGoodsImg> coverImgs;

    /** 详情图集合 */
    private List<WaterGoodsImg> detailsImgs;

    private String speVal;
}
