package com.qianhe.system.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品对象 water_goods
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Data
public class WaterGoods
{
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 标题 */
    @Excel(name = "标题")
    private String title;

    /** 类型 */
    @Excel(name = "类型")
    private Long goodsTypeId;

    /** 所属站点id */
    @Excel(name = "所属站点id")
    private String belongStationId;

    /** 封面图 */
    @Excel(name = "封面图")
    private String coverImg;

    /** 详情图 */
    @Excel(name = "详情图")
    private String detailsImg;

    /** 价格 */
    @Excel(name = "价格")
    private BigDecimal price;

    /** 销量 */
    @Excel(name = "销量")
    private String volume;

    /** 创建人 */
    private String  createUser;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 状态（1上架0下架） */
    @Excel(name = "状态", readConverterExp = "1=上架0下架")
    private Integer status;
    private String zt;

    private String openId;

    private String totalPrice;

    private String orderNo;

    /** 删除状态 */
    private String delFlag;

    /** 商品简介 */
    @Excel(name = "商品简介")
    private String spjj;
    //规格
    private String spe;
    private BigDecimal sjjg;

    private String speVal;

    private String  lbtype;
}
