package com.qianhe.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 建行工作密钥对象 ccb_key
 *
 * @author qianhe
 * @date 2024-04-26
 */
@Data
public class CcbKey extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 工作密钥 */
    private String ccbkey;

    /** 录入时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "录入时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lrsj;

    /** 是否过期(0/过期 1/使用) */
    @Excel(name = "是否过期(0/过期 1/使用)")
    private String sfgq;
}
