package com.qianhe.system.domain;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * @author yc
 * @version 1.0
 * @className CCBNotifyInfo
 * @date 2024/3/29 14:16
 * @description 建行回调实体类
 */
@Data
@ToString
@AllArgsConstructor
@NoArgsConstructor
public class CCBNotifyInfo {
    private String POSID;
    /**
     * 分行代码
     */
    @JSONField(name="BRANCHID")
    private String BRANCHID;
    /**
     * 订单号（最长30位）
     */
    @JSONField(name="ORDERID")
    private String ORDERID;
    /**
     * 付款金额
     */
    @JSONField(name="PAYMENT")
    private String PAYMENT;
    /**
     * 币种
     * 缺省为 01－人民币
     */
    @JSONField(name="CURCODE")
    private String CURCODE;
    /**
     * 备注信息1
     * 一般作为商户自定义备注信
     * 息使用，可在对账单中显示
     */
    @JSONField(name="REMARK1")
    private String REMARK1;
    /**
     * 备注信息2
     * 一般作为商户自定义备注信
     * 息使用，可在对账单中显示
     */
    @JSONField(name="REMARK2")
    private String REMARK2;
    /**
     * 账户类型
     * 服务器通知中有此字段返回且参与验签
     * AL:代表支付宝支付
     * WX:代表微信支付
     * 其他：代表建行支付或跨行付
     */
    @JSONField(name="ACC_TYPE")
    private String ACC_TYPE;
    /**
     * 成功－Y，失败－N
     */
    @JSONField(name="SUCCESS")
    private String SUCCESS;
    /**
     * 接口类型
     * 分行业务人员在 P2 员工渠道后台设置防钓鱼的开关。
     * 1- 防钓鱼接口
     */
    @JSONField(name="TYPE")
    private String TYPE;
    /**
     * Referer信息
     * 分行业务人员在P2员工渠道后台设置防钓鱼开关。
     * 1.开关关闭时，无此字段返回且不参与验签。
     * 2.开关打开时，有此字段返回且参与验签。
     */
    @JSONField(name="REFERER")
    private String REFERER;
    /**
     * 客户端IP
     * 客户在商户系统中的IP，即客户登陆（访问）商户系统时使用的IP）
     * 分行业务人员在P2员工渠道后台设置防钓鱼开关。
     * 1.开关关闭时，无此字段返回且不参与验签。
     * 2.开关打开时，有此字段返回且参与验签。
     */
    @JSONField(name="CLIENTIP")
    private String CLIENTIP;
    /**
     * 系统记账日期
     * 商户登陆商户后台设置返回记账日期的开关
     * 1.开关关闭时，无此字段返回且不参与验签。
     * 2.开关打开时，有此字段返回且参与验签。参数值格式为YYYYMMDD（如20100907）。
     */
    @JSONField(name="ACCDATE")
    private String ACCDATE;
    /**
     * 分期期数
     * 从商户传送的信息中获得;
     * 当分期期数为空或无此字段上送时，无此字段返回且不参与验签，否则有此字段返回且参与验签。
     */
    @JSONField(name="INSTALLNUM")
    private String INSTALLNUM;
    /**
     * 错误信息
     * 该值默认返回为空，商户无需处理，仅需参与验签即可。当有分期期数返回时，则有ERRMSG字段返回且参与验签，否则无此字段返回且不参与验签。
     */
    @JSONField(name="ERRMSG")
    private String ERRMSG;
    /**
     * 支付账户信息
     * 分行业务人员在P2员工渠道后台设置防钓鱼开关和返回账户信息的开关。
     * 1.开关关闭时，无此字段返回且不参与验签。
     * 2.开关打开但支付失败时，无此字段返回且不参与验签。
     * 3.开关打开且支付成功时，有此字段返回且参与验签。参数值格式如下：“姓名|账号加密后的密文”。
     * 解密方法请参考“商户通知验签包“文件夹下的《USERMSG》压缩包
     */
    @JSONField(name="USRMSG")
    private String USRMSG;
    /**
     * 客户加密信息
     * 分行业务人员在P2员工渠道后台设置防钓鱼开关和客户信息加密返回的开关。
     * 1.开关关闭时，无此字段返回且不参与验签
     * 2.开关打开时，有此字段返回且参数验签。参数值格式如下：“证件号密文|手机号密文”。该字段不可解密。
     */
    @JSONField(name="USRINFO")
    private String USRINFO;
    /**
     * 实付金额
     * 优惠之后的实际支付金额。
     * 目前只针对白名单商户返回，无此字段返回且不参与验签，有此字段返回且参与验签。
     */
    @JSONField(name="DISCOUNT")
    private String DISCOUNT;
    /**
     * 返回客户的积分使用情况，格式如下：
     * {“APnt_Hpn_Num”:”积分发生数量”,”APntCmpt_Amt”:”积分抵扣金额”}
     * 当综合积分字段为空或无此字段上送时，无此字段返回且不参与验签，否则有此字段返回且参与验签。
     */
    @JSONField(name="ZHJF")
    private String ZHJF;
    /**
     * 客户识别号
     * 提交建行的参数RETURN_FIELD打开对应开关才返回该字段。
     * 客户识别码, 微信、支付宝、龙支付时返回。
     * 有该字段返回时(无论返回值是空还是其他)，需参与验签，否则无需参与验签。
     */
    @JSONField(name="OPENID")
    private String OPENID;
    /**
     * 用户子标识
     * 提交建行的参数RETURN_FIELD打开对应开关才返回该字段。
     * 微信支付专有字段。
     * 子商户appid下用户唯一标识，如需返回则请求时需要传sub_appid。
     * 有该字段返回时(无论返回值是空还是其他)，需参与验签，否则无需参与验签。
     */
    @JSONField(name="SUB_OPENID")
    private String SUB_OPENID;
    /**
     * 支付详细信息
     * 支付详细信息。当RETURN_FIELD字段第四位上送1时返回。
     * 字段说明见下方[支付详细信息字段说明]
     * 格式如下：
     * {“TYPE“:"ALIPAY",“PAY_CHANNEL“:"BANKCARD",“DEBIT_CREDIT_TYPE“:"DEBIT_CARD",“THIRD_TRADE_NO“:"2018010521001004890523646975"}
     * 为防止特殊字符，建行会将该参数值用utf-8编码进行urlencode，因此商户需先decode之后才能拿到明文。
     * 编码之后为：
     * %7B%22TYPE%22%3A%22ALIPAY%22%2C%22PAY_CHANNEL%22%3A%22BANKCARD%22%2C%22DEBIT_CREDIT_TYPE%22%3A%22DEBIT_CARD%22%2C%22THIRD_TRADE_NO%22%3A%222018010521001004890523646975%22%7D
     * 有该字段返回时(无论返回值是空还是其他)，需参与验签，否则无需参与验签，参与签名的是encode之后的参数值。
     */
    @JSONField(name="PAYMENT_DETAILS")
    private String PAYMENT_DETAILS;
    /**
     * 数字签名
     */
    @JSONField(name="SIGN")
    private String SIGN;

}