package com.qianhe.system.controller.api;

import com.qianhe.common.constant.Constants;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.model.MpLoginUser;
import com.qianhe.common.core.domain.model.WxLoginBody;
import com.qianhe.common.utils.MessageUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.framework.manager.AsyncManager;
import com.qianhe.framework.manager.factory.AsyncFactory;
import com.qianhe.framework.util.UserInfoUtil;
import com.qianhe.framework.web.service.MpTokenService;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.service.api.IWxLoginService;
import com.qianhe.system.service.impl.WaterUserServiceImpl;
import com.qianhe.system.utils.WxUserInfoUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

import static com.qianhe.common.core.domain.AjaxResult.success;

@RestController
@RequestMapping("/wx")
public class WxLogin {

    @Autowired
    WxUserInfoUtils wxUserInfoUtils;
    @Autowired
    private WaterUserServiceImpl waterUserService;
    @Autowired
    private IWxLoginService wxLoginService;
    @Autowired
    private MpTokenService mpTokenService;
    @Autowired
    private UserInfoUtil userInfoUtil;

    /**
     * 获取用户openid和session_key
     * @param code 微信临时登录凭证
     * @return
     */
    @GetMapping("/getWxLoginInfo")
    public AjaxResult getWxLoginInfo(String code){
        //根据code查询微信用户的openid和session_key
        Map<String, String> wxLoginInfo = wxUserInfoUtils.getWxLoginInfo(code);
        return AjaxResult.success(wxLoginInfo);
    }

    /**
     *
     * 获取微信用户手机号
     */
    @GetMapping("/getPhoneNumber")
    public AjaxResult getPhoneNumber(@RequestParam("code") String code){
        String wxUserPhone = wxUserInfoUtils.getWxUserPhone(code);
        return AjaxResult.success().put("phoneNumber",wxUserPhone);
    }

    /**
     * 小程序登录
     * @param code 微信登录临时凭证
     * @return
     */
    @GetMapping("/login")

    public AjaxResult login(@RequestParam("code") String code,@RequestParam("phoneNum") String phoneNum){
        AjaxResult ajaxResult = AjaxResult.success();

        //根据code查询微信用户的openid和session_key
        Map<String, String> wxLoginInfo = wxUserInfoUtils.getWxLoginInfo(code);
        WxLoginBody wxLoginBody = new WxLoginBody();
        wxLoginBody.setOpenId(wxLoginInfo.get("openid"));
        wxLoginBody.setPhone(phoneNum);
        MpLoginUser login = wxLoginService.login(wxLoginBody);
        if (StringUtils.isNull(login)) {
            return AjaxResult.error("login error");
        }
        ajaxResult.put("loginInfo",wxLoginInfo);
        ajaxResult.put("isNewUser",login.getIsNewUser());
        AsyncManager.me().execute(AsyncFactory.recordLogininfor(login.getNickName(), Constants.LOGIN_SUCCESS, MessageUtils.message("user.login.success")));
        String token = mpTokenService.createToken(login);
        ajaxResult.put(Constants.TOKEN, token);
        return ajaxResult;
    }

    /**
     * 修改用户信息
     */
    @PostMapping("/updateUser")
    public AjaxResult updateUser(@RequestBody WaterUser waterUser){
        waterUser.setUserType("1");
        if(StringUtils.isEmpty(waterUser.getNickName())){
            waterUser.setNickName("微信用户");
        }
        return success(waterUserService.updateUserByOpenId(waterUser));
    }

    /**
     * 获取用户信息
     * @return
     */
    @GetMapping("/getUserInfo")
    public AjaxResult getUserInfo(WaterUser user){
        //获取当前登录用户openid
        String openId = user.getOpenId();
        Map<String,Object> map = new HashMap<>();
        //根据openid查询用户信息
        WaterUser waterUser = waterUserService.selectUserByOpenId(openId,"1");
        map.put("userId",waterUser.getId());
        map.put("nickName",waterUser.getNickName());
        map.put("phoneNum",waterUser.getPhoneNum());
        map.put("stationName",waterUser.getStationName());
        map.put("userType",waterUser.getUserType());
        map.put("userGender",waterUser.getUserGender());
        AsyncManager.me().execute(AsyncFactory.recordLogininfor(waterUser.getNickName(), Constants.LOGIN_SUCCESS, MessageUtils.message("user.login.success")));
        //存在
        MpLoginUser loginUser = new MpLoginUser();
        loginUser.setOpenId(openId);
        loginUser.setUserId(waterUser.getId());
        loginUser.setNickName(waterUser.getNickName());
        loginUser.setIsNewUser("0");
        String token = mpTokenService.createToken(loginUser);
        map.put(Constants.TOKEN, token);
        return AjaxResult.success(map);
    }

    /**
     * 自定义退出登录
     */
    @GetMapping("/logout")
    public AjaxResult logout(HttpServletRequest request) {
        String mpToken = mpTokenService.getToken(request);
        MpLoginUser loginUser = mpTokenService.getMpLoginUser(mpToken);
        if (StringUtils.isNotNull(loginUser))
        {

            String userName = loginUser.getNickName();
            // 删除用户缓存记录
            mpTokenService.delMpLoginUser(loginUser.getMpToken());
            // 记录用户退出日志
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(userName, Constants.LOGOUT, "退出成功"));
        }
        return AjaxResult.success("退出成功");
    }
}
