package com.qianhe.system.controller.api;

import com.qianhe.common.constant.Constants;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.model.MpLoginUser;
import com.qianhe.common.core.domain.model.WxLoginBody;
import com.qianhe.common.exception.ServiceException;
import com.qianhe.common.utils.MessageUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.framework.manager.AsyncManager;
import com.qianhe.framework.manager.factory.AsyncFactory;
import com.qianhe.framework.util.UserInfoUtil;
import com.qianhe.framework.web.service.MpTokenService;
import com.qianhe.system.domain.WaterStationUser;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.mapper.WaterStationUserMapper;
import com.qianhe.system.service.IWaterStationUserService;
import com.qianhe.system.service.api.IWxLoginService;
import com.qianhe.system.service.impl.WaterUserServiceImpl;
import com.qianhe.system.utils.SsAccessTokenUtils;
import com.qianhe.system.utils.SsWxUserInfoUtils;
import com.qianhe.system.utils.WxUserInfoUtils;
import com.qianhe.system.vo.WaterStationUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

import static com.qianhe.common.core.domain.AjaxResult.success;

@RestController
@RequestMapping("/ssWx")
public class SsWxLogin {

    @Autowired
    SsWxUserInfoUtils wxUserInfoUtils;
    @Autowired
    private WaterUserServiceImpl waterUserService;
    @Autowired
    private IWxLoginService wxLoginService;
    @Autowired
    private MpTokenService mpTokenService;
    @Autowired
    private UserInfoUtil userInfoUtil;
    @Autowired
    private IWaterStationUserService waterStationUserService;

    @Autowired
    private WaterStationUserMapper waterStationUserMapper;

    /**
     * 获取用户openid和session_key
     * @param code 微信临时登录凭证
     * @return
     */
    @GetMapping("/getWxLoginInfo")
    public AjaxResult getWxLoginInfo(String code){
        //根据code查询微信用户的openid和session_key
        Map<String, String> wxLoginInfo = wxUserInfoUtils.getWxLoginInfo(code);
        return AjaxResult.success(wxLoginInfo);
    }

    /**
     *
     * 获取微信用户手机号
     */
    @GetMapping("/getPhoneNumber")
    public AjaxResult getPhoneNumber(@RequestParam("code") String code){
        String wxUserPhone = wxUserInfoUtils.getWxUserPhone(code);
        return AjaxResult.success().put("phoneNumber",wxUserPhone);
    }

    /**
     * 小程序登录
     * @param code 微信登录临时凭证
     * @return
     */
    @GetMapping("/login")
    public AjaxResult login(@RequestParam("code") String code,@RequestParam("phoneNum") String phoneNum){
        AjaxResult ajaxResult = AjaxResult.success();
       //查询当前用户是否为配送工
        WaterStationUserVo waterStationUserVo = waterStationUserMapper.selectWaterStationUserByPhone(Long.parseLong(phoneNum));
        if(waterStationUserVo==null){
            return AjaxResult.error("您无权限登录，请联系管理员！");
        }
        //根据code查询微信用户的openid和session_key
        Map<String, String> wxLoginInfo = wxUserInfoUtils.getWxLoginInfo(code);

        WaterStationUserVo userVo=new WaterStationUserVo();
        userVo.setPhone(Long.parseLong(phoneNum));
        userVo.setWxOpenid(wxLoginInfo.get("openid"));
        int i =waterStationUserMapper.updateWaterStationUserByphone(userVo);
//        WxLoginBody wxLoginBody = new WxLoginBody();
//        wxLoginBody.setOpenId(wxLoginInfo.get("openid"));
//        wxLoginBody.setPhone(phoneNum);
//
//        MpLoginUser login = wxLoginService.ssLogin(wxLoginBody);
//        if (StringUtils.isNull(login)) {
//            return AjaxResult.error("您无权限登录，请联系管理员！");
//        }
        waterStationUserVo.setOpenId(waterStationUserVo.getWxOpenid());
        ajaxResult.put("loginInfo",waterStationUserVo);
        ajaxResult.put("isNewUser","0");
        AsyncManager.me().execute(AsyncFactory.recordLogininfor(waterStationUserVo.getName(), Constants.LOGIN_SUCCESS, MessageUtils.message("user.login.success")));
        MpLoginUser loginUser = new MpLoginUser();
        loginUser.setOpenId(waterStationUserVo.getWxOpenid());
        loginUser.setUserId(waterStationUserVo.getId());
        loginUser.setNickName(waterStationUserVo.getName());
        loginUser.setIsNewUser("0");
        String token = mpTokenService.createToken(loginUser);
        ajaxResult.put(Constants.TOKEN, token);
        return ajaxResult;
    }

    /**
     * 修改用户信息
     */
    @PostMapping("/updateUser")
    public AjaxResult updateUser(@RequestBody WaterUser waterUser){
        waterUser.setUserType("2");
        if (StringUtils.isEmpty(waterUser.getNickName())){
            waterUser.setNickName("微信用户");
        }
        return success(waterUserService.updateUserByOpenId(waterUser));
    }

   /* *//**
     * 获取用户信息
     * @return
     *//*
    @GetMapping("/getUserInfo")
    public AjaxResult getUserInfo(){
        //获取当前登录用户openid
        String openId = userInfoUtil.getOpenId();
        Map<String,Object> map = new HashMap<>();
        //根据openid查询用户信息
        WaterUser waterUser = waterUserService.selectUserByOpenId(openId,"2");
        map.put("userId",waterUser.getId());
        map.put("nickName",waterUser.getNickName());
        map.put("phoneNum",waterUser.getPhoneNum());
        map.put("stationName",waterUser.getStationName());
        map.put("userType",waterUser.getUserType());
        map.put("userGender",waterUser.getUserGender());
        //查询送水工站点信息
        WaterStationUserVo waterStationUser = waterStationUserService.selectWaterStationUserByPhone(waterUser.getPhoneNum());
        if (StringUtils.isNull(waterStationUser)){
            return AjaxResult.error("未查询到你的站点信息，请联系管理员！");
        }
        map.put("waterStationUser",waterStationUser);
        return AjaxResult.success(map);
    }*/

    /**
     * 获取用户信息
     * @return
     */
    @GetMapping("/getUserInfo")
    public AjaxResult getUserInfo(WaterUser user){
        //获取当前登录用户openid
        //String openId = userInfoUtil.getOpenId();
        String openId = user.getOpenId();
        Map<String,Object> map = new HashMap<>();
        //根据openid查询用户信息
        WaterStationUser waterUser=waterStationUserMapper.selectUserByOpenId(openId);
        if (StringUtils.isNull(waterUser)){
            return AjaxResult.warn("未查询到你的站点信息，请联系管理员！");
        }
        waterUser.setOpenId(waterUser.getWxOpenid());
        map.put("userId",waterUser.getId());
        map.put("nickName",waterUser.getName());
        map.put("phoneNum",waterUser.getPhone());
        map.put("stationName",waterUser.getStationName());
        map.put("userType","2");
        map.put("userGender",waterUser.getGender());
        AsyncManager.me().execute(AsyncFactory.recordLogininfor(waterUser.getName(), Constants.LOGIN_SUCCESS, MessageUtils.message("user.login.success")));
        //存在
        MpLoginUser loginUser = new MpLoginUser();
        loginUser.setOpenId(openId);
        loginUser.setUserId(waterUser.getId());
        loginUser.setNickName(waterUser.getName());
        loginUser.setIsNewUser("0");
        String token = mpTokenService.createToken(loginUser);
        map.put(Constants.TOKEN, token);
        //查询送水工站点信息
//        WaterStationUserVo waterStationUser = waterStationUserService.selectWaterStationUserByPhone(waterUser.getPhone());

        map.put("waterStationUser",waterUser);
        return AjaxResult.success(map);
    }

    /**
     * 自定义退出登录
     */
    @GetMapping("/logout")
    public AjaxResult logout(HttpServletRequest request) {
        String mpToken = mpTokenService.getToken(request);
        MpLoginUser loginUser = mpTokenService.getMpLoginUser(mpToken);
        if (StringUtils.isNotNull(loginUser))
        {

            String userName = loginUser.getNickName();
            // 删除用户缓存记录
            mpTokenService.delMpLoginUser(loginUser.getMpToken());
            // 记录用户退出日志
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(userName, Constants.LOGOUT, "退出成功"));
        }
        return AjaxResult.success("退出成功");
    }
}
