//package com.qianhe.system.controller;
//
//import com.alibaba.fastjson.JSONObject;
//import com.alibaba.fastjson.TypeReference;
//import com.qianhe.system.config.WechatPayConfig;
//import com.qianhe.system.domain.*;
//import com.qianhe.system.mapper.WaterOrderLogMapper;
//import com.qianhe.system.mapper.WaterOrderMapper;
//import com.qianhe.system.mapper.WaterWxpayOrderMapper;
//import com.qianhe.system.utils.WechatPayValidator;
//import com.qianhe.system.vo.WaterOrderVo;
//import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
//import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
//import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
//import com.wechat.pay.contrib.apache.httpclient.cert.CertificatesManager;
//import com.wechat.pay.contrib.apache.httpclient.exception.HttpCodeException;
//import com.wechat.pay.contrib.apache.httpclient.exception.NotFoundException;
//import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//
//
//import javax.annotation.Resource;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//
//import java.io.ByteArrayInputStream;
//import java.io.IOException;
//import java.io.UnsupportedEncodingException;
//import java.lang.reflect.Field;
//
//import java.math.BigDecimal;
//import java.security.GeneralSecurityException;
//import java.security.NoSuchAlgorithmException;
//import java.security.PrivateKey;
//import java.text.ParseException;
//import java.text.SimpleDateFormat;
//import java.util.Date;
//import java.util.HashMap;
//import java.util.Map;
//import java.util.concurrent.locks.ReentrantLock;
//import java.util.stream.Collectors;
//import java.util.stream.Stream;
//
///**
// * @author yc
// * @version 1.0
// * @className CallbackController
// * @date 2024/3/15 15:26
// * @description 微信回调
// */
//
//@RestController
//@Slf4j
//@RequestMapping("/callback")
//public class WxPaybackController {
//    @Resource
//    private WechatPayConfig wechatPayConfig;
//
//    @Autowired
//    private WaterWxpayOrderMapper wxpayOrderMapper;
//
//    @Autowired
//    private WaterOrderLogMapper orderLogMapper;
//
//    @Autowired
//    private WaterOrderMapper orderMapper;
//
//    private final ReentrantLock lock = new ReentrantLock();
//
//    private String pk = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+vQS+6VGcsX6i\n" +
//            "Au5HhEXviSfTuI+F3ZHGD/9m/3sPNxIsiA/46E9vk0+Ulxmaxr5x6KNbyko/XVmQ\n" +
//            "MN1vxFO/rGpqk24shDWZpxyMEwMxvw4EcbhbGmzRoxmrwUbujmJznIq6JcqqaBHa\n" +
//            "Z9LwHzVWtOZsRwHVr6KivRZr27bN3aEv26nnMTDkg1tkwi0AKG4EmxlYU5zjnFXh\n" +
//            "3TDkOZYZsq24bXllSCXlTCCWpBgPbNyBzAshT3M9nD4GeW+sqrnsVMEbaSxjd6xg\n" +
//            "uB28OCxyOb1BJKXEZYQJBmQ+ik8GoNQtx/00tE1Y5GPH+QONs1sYlQhu4FFTtvvS\n" +
//            "069DIOfjAgMBAAECggEBAKg8NkxhpS9tSwGBTkRcQgdGVY+kMUtkpCgrgh2J6DQC\n" +
//            "YhBPLq9f0HjcWQv5vobLF72G8VeL9LMxFkddImNrqmbcn7xDL6EqN9DAGijeuCmP\n" +
//            "l8CJwY7xntvFXWYmAvd1NRc+EwqfPMPTKTQX8XEERdqlkrwcYVzmHrAl0fnugK3Q\n" +
//            "btsO931xHGJ98CSVOMURiRmTdjKAahXYIlWfU0Xdqb+16uIPD31tLC17Kf5+Odpd\n" +
//            "Rv9rxLBrp6FxuA+fwkKT+f3bNxLOQfmsb+0nuE/8lNe3VslV96K+CUB7MELQ3wx3\n" +
//            "hQ5BgVa3JNpOlY5TMjyP+Yi+OEA+KJ/xPMKsieP6fFECgYEA+FxERDwoAWjn5V5x\n" +
//            "7yVAJ4Vnd5WaIxIU6J8YDjDX5CEzXsICoubxioAPbZoC93T/6h8WGWvm3s8FfIlp\n" +
//            "dWRIAK/YA4fqAwcEyTuk6p2upU1IAyjz09n+OshIvBZ+j/b05xFk5nMM616HZrAn\n" +
//            "mIB1isDn8UhKPKjhx2JatOvdBqsCgYEAxJsAoizmYHYeY0aW+HX2h9LqImxCuPmK\n" +
//            "izaMZCxq9RBGwGT/UyHXo3CBr+SILvjAYtKDi5danIygiVp76yBWBQQmKh5f0z7m\n" +
//            "FoPRwmf7o1qMV+KuFdydLuinA5864aONOEeoQOBuWP6fJ11+37ezVTsUyuC+fjhX\n" +
//            "1+uNnhNqg6kCgYBjXxd5bdBb8AuI/Kb9lpv6tCfX8yW/DocLJEzNsMFQ5+/T5DCF\n" +
//            "2X2feumxYsP5GvkiRdnjxgaT86UwVRK7A6rDi5gUoZcCKxbBJXow3XJ5dVhw2zvj\n" +
//            "8f8EqgpgJ2fwVlFa+tyyUCpFKodmkOjm3c8p+1FSeygo6TGdQz8j0JOZDQKBgQCx\n" +
//            "+2RybFVOZAAUfXX0jc3VneGpsfohPH7okkQ7914IZmi2iXf/CTcO1a4BztBePYDk\n" +
//            "tZCykR1NdZ1rWsetzsMwnVXzcTXsphdjsIf3B21tr243rZVNYz/ElIeFpuOGGyqg\n" +
//            "FXbC7KnY1QC9gU13N/UYJnknRJgO6fDUHoFA5nDZqQKBgADTGuWavhnw1SCRYZhz\n" +
//            "QtonO5hXjNjwZHcmEaEneI3+9X64TQgXY1hQe3WWLUwDNyAhlsT8y1Jl1kgL0tJP\n" +
//            "mxz0fsu47RdFR1rX+3ZIF5jNaxR6UIN2GQLlhvB7PCl7znKpph/nVthTO681Vx3V\n" +
//            "mP/wQpwy8cWtmbyl7lcvVRN5";
//    String serialNo = "2562AB35D9BFE5CB875FA73954B6F51421E0F364";
//    /**
//     * 支付回调处理
//     *
//     * @param request
//     * @param response
//     * @return
//     */
//    @PostMapping("/payNotify/")
//    public Map<String, String> payNotify(HttpServletRequest request, HttpServletResponse response) throws GeneralSecurityException, IOException, NotFoundException, HttpCodeException {
//        log.info("支付回调");
//
//        // 处理通知参数
//        Map<String, Object> bodyMap = getNotifyBody(request);
//        if (bodyMap == null) {
//            return falseMsg(response);
//        }
//
//        log.warn("=========== 在对业务数据进行状态检查和处理之前，要采用数据锁进行并发控制，以避免函数重入造成的数据混乱 ===========");
//        if (lock.tryLock()) {
//            try {
//                // 解密resource中的通知数据
//                String resource = bodyMap.get("resource").toString();
//                Map<String, Object> resourceMap = WechatPayValidator.decryptFromResource(resource, wechatPayConfig.getApiV3Key(), 1);
//                System.out.println("resourceMap============"+resourceMap);
//                String outTradeNo = resourceMap.get("out_trade_no").toString();
//                String attach = resourceMap.get("attach").toString();
//                String appId = resourceMap.get("appid").toString();
//                String tradeType = resourceMap.get("trade_type").toString();
//                String tradeState = resourceMap.get("trade_state").toString();
//                String desc = resourceMap.get("trade_state_desc").toString();
//                String successTime = resourceMap.get("success_time").toString();
//                String bankType = resourceMap.get("bank_type").toString();
//
//                Object payer = resourceMap.get("payer");
//                UserPay user = JSONObject.parseObject(JSONObject.toJSONString(payer),UserPay.class);
//                String openId = user.getOpenId();
//
//                Object amount = resourceMap.get("amount");
//                Amount amount1 = JSONObject.parseObject(JSONObject.toJSONString(amount),Amount.class);
//                String total = amount1.getTotal();
//
//
//                WaterWxpayOrder wxpayOrder = new WaterWxpayOrder();
//                wxpayOrder.setOutTradeNo(outTradeNo);
//                wxpayOrder.setTradeState(tradeState);
//                wxpayOrder.setSuccessTime(successTime);
//                wxpayOrder.setOpenId(openId);
//                wxpayOrder.setTradeStateDesc(desc);
//                wxpayOrder.setAppId(appId);
//                wxpayOrder.setTradeType(tradeType);
//                wxpayOrder.setBankType(bankType);
//
//                int pay = wxpayOrderMapper.insertWxpay(wxpayOrder);
//
//                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
//                Date date = sdf.parse(successTime);
//                WaterOrderLog orderLog = new WaterOrderLog();
//                orderLog.setPayNum(attach);
//                orderLog.setPayTime(date);
//                orderLog.setPayMoney(new BigDecimal(total));
//                int iLog = orderLogMapper.insertWaterOrderLog(orderLog);
//
//                if(desc.equals("支付成功")){
//
//                    WaterOrderVo orderVo = new WaterOrderVo();
//                    orderVo.setOrderNum(attach);
//                    int orderI = orderMapper.updateByOrderNum(orderVo);
//                }
//                // String transactionId = resourceMap.get("transaction_id").toString();
//                // 更改状态 获取订单号  修改订单状态为已支付
//
//                // TODO 根据订单号，做幂等处理，并且在对业务数据进行状态检查和处理之前，要采用数据锁进行并发控制，以避免函数重入造成的数据混乱
//                log.warn("=========== 根据订单号，做幂等处理 ===========");
//            } catch (ParseException e) {
//                e.printStackTrace();
//            } finally {
//                //要主动释放锁
//                lock.unlock();
//            }
//        }
//
//        //成功应答
//        return trueMsg(response);
//    }
//
//
//    /**
//     * 实体对象转成Map
//     * @param obj 实体对象
//     * @return
//     */
//    public static Map<String, Object> object2Map(Object obj) {
//        Map<String, Object> map = new HashMap<>();
//        if (obj == null) {
//            return map;
//        }
//        Class clazz = obj.getClass();
//        Field[] fields = clazz.getDeclaredFields();
//        try {
//            for (Field field : fields) {
//                field.setAccessible(true);
//                map.put(field.getName(), field.get(obj));
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return map;
//    }
//
//
//    /**
//     * 退款回调处理
//     *
//     * @param request
//     * @param response
//     * @return
//     */
//    @PostMapping("/refundNotify")
//    public Map<String, String> refundNotify(HttpServletRequest request, HttpServletResponse response) throws NotFoundException, HttpCodeException, GeneralSecurityException, IOException {
//        log.info("退款回调");
//
//        // 处理通知参数
//        Map<String, Object> bodyMap = getNotifyBody(request);
//        if (bodyMap == null) {
//            return falseMsg(response);
//        }
//
//        log.warn("=========== 在对业务数据进行状态检查和处理之前，要采用数据锁进行并发控制，以避免函数重入造成的数据混乱 ===========");
//        if (lock.tryLock()) {
//            try {
//                // 解密resource中的通知数据
//                String resource = bodyMap.get("resource").toString();
//                Map<String, Object> resourceMap = WechatPayValidator.decryptFromResource(resource, wechatPayConfig.getApiV3Key(), 2);
//                String orderNo = resourceMap.get("out_trade_no").toString();
////                String transactionId = resourceMap.get("transaction_id").toString();
//                log.info("退款所有参数" + resourceMap);
//
//                // TODO 根据订单号，做幂等处理，并且在对业务数据进行状态检查和处理之前，要采用数据锁进行并发控制，以避免函数重入造成的数据混乱
//                // 更改订单状态为已退款
//                log.warn("=========== 根据订单号，做幂等处理 ===========");
//            } finally {
//                //要主动释放锁
//                lock.unlock();
//            }
//        }
//
//        //成功应答
//        return trueMsg(response);
//    }
//
//    private Map<String, Object> getNotifyBody(HttpServletRequest request) throws GeneralSecurityException, IOException, NotFoundException, HttpCodeException {
//        //处理通知参数
//        String body = WechatPayValidator.getRequestBody(request);
//        log.info("退款回调参数：{}", body);
//
//        // 转换为Map
//        Map<String, Object> bodyMap = JSONObject.parseObject(body, new TypeReference<Map<String, Object>>() {
//        });
//
//
//        //微信传递过来的签名
//        String signature = request.getHeader("Wechatpay-Signature");
//
//        //证书序列号（微信平台）
//        String serialNo = request.getHeader("Wechatpay-Serial");
//
//        //随机串
//        String nonceStr = request.getHeader("Wechatpay-Nonce");
//
//
//        String timestamp = request.getHeader("Wechatpay-Timestamp");
//
//
//        PrivateKey pk1 = PemUtil.loadPrivateKey(new ByteArrayInputStream(pk.getBytes("utf-8")));
//
//        // 获取证书管理器实例
//        CertificatesManager certificatesManager = CertificatesManager.getInstance();
//        // 向证书管理器增加需要自动更新平台证书的商户信息
//        certificatesManager.putMerchant(wechatPayConfig.getMchId(),
//                new WechatPay2Credentials(wechatPayConfig.getMchId(), new PrivateKeySigner(wechatPayConfig.getSerialNo(), pk1)),
//                wechatPayConfig.getApiV3Key().getBytes("UTF-8"));
//        // 从证书管理器中获取verifier
//        Verifier verifier = certificatesManager.getVerifier(wechatPayConfig.getMchId());
//
//        String VerifySignature = Stream.of(timestamp, nonceStr, body).collect(Collectors.joining("\n", "", "\n"));
//
//        boolean verify = verifier.verify(serialNo, VerifySignature.getBytes(), signature);
//
//        if(!verify){
//            log.info("通知验签失败");
//        }
//        log.info("通知验签成功");
//        return bodyMap;
//    }
//
//
//
//
//
//
//
//
//    private Map<String, String> falseMsg(HttpServletResponse response) {
//        Map<String, String> resMap = new HashMap<>(8);
//        //失败应答
//        response.setStatus(500);
//        resMap.put("code", "ERROR");
//        resMap.put("message", "通知验签失败");
//        return resMap;
//    }
//
//    private Map<String, String> trueMsg(HttpServletResponse response) {
//        Map<String, String> resMap = new HashMap<>(8);
//        //成功应答
//        response.setStatus(200);
//        resMap.put("code", "SUCCESS");
//        resMap.put("message", "成功");
//        return resMap;
//    }
//
//}