//package com.qianhe.system.controller;
//
//import cn.hutool.core.codec.Base64Encoder;
//import cn.hutool.core.util.StrUtil;
//import cn.hutool.crypto.SecureUtil;
//import cn.hutool.crypto.asymmetric.SignAlgorithm;
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONObject;
//import com.alibaba.fastjson.TypeReference;
//import com.qianhe.common.core.domain.AjaxResult;
//import com.qianhe.common.utils.DateUtils;
//import com.qianhe.common.utils.StringUtils;
//import com.qianhe.system.config.WechatPayConfig;
//import com.qianhe.system.domain.WaterGoods;
//import com.qianhe.system.domain.WaterOrder;
//import com.qianhe.system.mapper.WaterOrderMapper;
//import com.qianhe.system.service.IWaterOrderService;
//import com.qianhe.system.utils.WechatPayRequest;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//import sun.misc.BASE64Decoder;
//
//import javax.annotation.Resource;
//import java.io.IOException;
//import java.math.BigDecimal;
//import java.nio.charset.StandardCharsets;
//import java.nio.file.Files;
//import java.nio.file.Paths;
//import java.security.KeyFactory;
//import java.security.PrivateKey;
//import java.security.Signature;
//import java.security.spec.PKCS8EncodedKeySpec;
//import java.text.SimpleDateFormat;
//import java.util.Base64;
//import java.util.HashMap;
//import java.util.Map;
//import java.util.Random;
//
//import static com.qianhe.common.core.domain.AjaxResult.success;
//
///**
// * @author yc
// * @version 1.0
// * @className PayController
// * @date 2024/3/15 15:03
// * @description 微信支付
// */
//
//@Slf4j
//@RestController
//@RequestMapping("/pay")
//public class WxPayController {
//    @Resource
//    private WechatPayConfig wechatPayConfig;
//
//    @Resource
//    private WechatPayRequest wechatPayRequest;
//
//    @Autowired
//    private IWaterOrderService waterOrderService;
//
//    @Autowired
//    private WaterOrderMapper waterOrderMapper;
//
//
//    private String pk = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+vQS+6VGcsX6i\n" +
//            "Au5HhEXviSfTuI+F3ZHGD/9m/3sPNxIsiA/46E9vk0+Ulxmaxr5x6KNbyko/XVmQ\n" +
//            "MN1vxFO/rGpqk24shDWZpxyMEwMxvw4EcbhbGmzRoxmrwUbujmJznIq6JcqqaBHa\n" +
//            "Z9LwHzVWtOZsRwHVr6KivRZr27bN3aEv26nnMTDkg1tkwi0AKG4EmxlYU5zjnFXh\n" +
//            "3TDkOZYZsq24bXllSCXlTCCWpBgPbNyBzAshT3M9nD4GeW+sqrnsVMEbaSxjd6xg\n" +
//            "uB28OCxyOb1BJKXEZYQJBmQ+ik8GoNQtx/00tE1Y5GPH+QONs1sYlQhu4FFTtvvS\n" +
//            "069DIOfjAgMBAAECggEBAKg8NkxhpS9tSwGBTkRcQgdGVY+kMUtkpCgrgh2J6DQC\n" +
//            "YhBPLq9f0HjcWQv5vobLF72G8VeL9LMxFkddImNrqmbcn7xDL6EqN9DAGijeuCmP\n" +
//            "l8CJwY7xntvFXWYmAvd1NRc+EwqfPMPTKTQX8XEERdqlkrwcYVzmHrAl0fnugK3Q\n" +
//            "btsO931xHGJ98CSVOMURiRmTdjKAahXYIlWfU0Xdqb+16uIPD31tLC17Kf5+Odpd\n" +
//            "Rv9rxLBrp6FxuA+fwkKT+f3bNxLOQfmsb+0nuE/8lNe3VslV96K+CUB7MELQ3wx3\n" +
//            "hQ5BgVa3JNpOlY5TMjyP+Yi+OEA+KJ/xPMKsieP6fFECgYEA+FxERDwoAWjn5V5x\n" +
//            "7yVAJ4Vnd5WaIxIU6J8YDjDX5CEzXsICoubxioAPbZoC93T/6h8WGWvm3s8FfIlp\n" +
//            "dWRIAK/YA4fqAwcEyTuk6p2upU1IAyjz09n+OshIvBZ+j/b05xFk5nMM616HZrAn\n" +
//            "mIB1isDn8UhKPKjhx2JatOvdBqsCgYEAxJsAoizmYHYeY0aW+HX2h9LqImxCuPmK\n" +
//            "izaMZCxq9RBGwGT/UyHXo3CBr+SILvjAYtKDi5danIygiVp76yBWBQQmKh5f0z7m\n" +
//            "FoPRwmf7o1qMV+KuFdydLuinA5864aONOEeoQOBuWP6fJ11+37ezVTsUyuC+fjhX\n" +
//            "1+uNnhNqg6kCgYBjXxd5bdBb8AuI/Kb9lpv6tCfX8yW/DocLJEzNsMFQ5+/T5DCF\n" +
//            "2X2feumxYsP5GvkiRdnjxgaT86UwVRK7A6rDi5gUoZcCKxbBJXow3XJ5dVhw2zvj\n" +
//            "8f8EqgpgJ2fwVlFa+tyyUCpFKodmkOjm3c8p+1FSeygo6TGdQz8j0JOZDQKBgQCx\n" +
//            "+2RybFVOZAAUfXX0jc3VneGpsfohPH7okkQ7914IZmi2iXf/CTcO1a4BztBePYDk\n" +
//            "tZCykR1NdZ1rWsetzsMwnVXzcTXsphdjsIf3B21tr243rZVNYz/ElIeFpuOGGyqg\n" +
//            "FXbC7KnY1QC9gU13N/UYJnknRJgO6fDUHoFA5nDZqQKBgADTGuWavhnw1SCRYZhz\n" +
//            "QtonO5hXjNjwZHcmEaEneI3+9X64TQgXY1hQe3WWLUwDNyAhlsT8y1Jl1kgL0tJP\n" +
//            "mxz0fsu47RdFR1rX+3ZIF5jNaxR6UIN2GQLlhvB7PCl7znKpph/nVthTO681Vx3V\n" +
//            "mP/wQpwy8cWtmbyl7lcvVRN5";
//
//    /**
//     * 预支付订单生成入口
//     */
//    @GetMapping("/transactions")
//    public AjaxResult transactions(WaterGoods goods) throws Exception {
//
//        // 统一参数封装
//        Map<String, Object> params = new HashMap<>(10);
//        // 1,appid：公众号或移动应用的唯一标识符。
//        params.put("appid", wechatPayConfig.getAppId());
//        // 2,mch_id：商户号，由微信支付分配。
//        params.put("mchid", wechatPayConfig.getMchId());
//        // 3.description body：商品描述。
//        params.put("description", goods.getTitle());
//        // 4.out_trade_no：商户订单号，由商户自定义。
//        params.put("out_trade_no", goods.getOrderNo());
//        // 5.notify_url：接收微信支付异步通知回调地址。
//        params.put("notify_url", wechatPayConfig.getNotifyUrl());
//        //6.
//        params.put("attach",goods.getOrderNo());
//        // 7.total_fee：订单总金额，单位为分。
//        Map<String, Object> amountMap = new HashMap<>(4);
//
//        // 金额单位为分
//        amountMap.put("total", (int)Math.floor(Double.parseDouble(goods.getTotalPrice())*100));
//        amountMap.put("currency", "CNY");
//        params.put("amount", amountMap);
//
//
//        // 7.openid：用户在商户appid下的唯一标识。
//        Map<String, Object> payerMap = new HashMap<>(4);
//        // openid  需要前端小程序通过用户code 请求微信接口获取用户唯一openid  不懂的看官方文档：https://developers.weixin.qq.com/doc/aispeech/miniprogram/quickuse.html
//        payerMap.put("openid", goods.getOpenId());
//        params.put("payer", payerMap);
//
//        String paramsStr = JSON.toJSONString(params);
//        log.info("请求参数 ===> {}" + paramsStr);
//
//        // 微信预支付下单接口路径
//        String payUrl = "https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi";
//        // 获取支付 prepay_id参数
//        String resStr = wechatPayRequest.wechatHttpOrderPost(payUrl, paramsStr);
//
//
//        Map<String, Object> resMap = JSONObject.parseObject(resStr, new TypeReference<Map<String, Object>>() {
//        });
//        Object prepayId = resMap.get("prepay_id");
//
//        // 得到当前系统时间搓
//        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000);
//
//
//        String nonceStr = getRandomStringByLength(32);
//
//
//        // 将签名时数据和签名一起返回前端用于前端吊起支付
//        Map<String, Object> map = new HashMap<>();
//        // 小程序id
//        map.put("appId", wechatPayConfig.getAppId());
//        // 时间戳
//        map.put("timeStamp", timeStamp);
//        // 随机字符串
//        map.put("nonceStr", nonceStr);
//        // 预支付交易会话ID
//        map.put("package", "prepay_id=" + prepayId);
//        // 签名方式
//        map.put("signType", "RSA");
//
//
//        // 获取签名
//        String sign = getPaySign(timeStamp,nonceStr,"prepay_id="+prepayId);
//
//        // 签名
//        map.put("paySign", sign);
//        System.out.println(map);
//        return success(map);
//    }
//
//
//    public String getPaySign(String timeStamp, String nonceStr, String packageStr) throws Exception {
//        String sourceText = wechatPayConfig.getAppId() + StrUtil.LF + timeStamp + StrUtil.LF + nonceStr + StrUtil.LF + packageStr + StrUtil.LF;
//        log.info("微信支付签名原文：{}", sourceText);
//        /*byte[] sign = SecureUtil.sign(SignAlgorithm.SHA256withRSA)
//                .setPrivateKey(wechatPayConfig.getPrivateKey(wechatPayConfig.getKeyPemPath()))
//                .sign(sourceText);*/
//        PrivateKey key = getPrivateKey(pk);
//        byte[] sign = SecureUtil.sign(SignAlgorithm.SHA256withRSA)
//                .setPrivateKey(key)
//                .sign(sourceText);
//        String paySign = Base64Encoder.encode(sign);
//        log.info("微信支付签名密文：{}", paySign);
//        return paySign;
//    }
//
//    public static PrivateKey getPrivateKey(String key) throws Exception {
//        byte[] keyBytes;
//        keyBytes = (new BASE64Decoder()).decodeBuffer(key);
//        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
//        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
//        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
//        return privateKey;
//    }
//
//
//
//    /**
//     * 获取一定长度的随机字符串
//     *
//     * @param length 指定字符串长度
//     * @return 一定长度的字符串
//     */
//    public static String getRandomStringByLength(int length) {
//        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
//        Random random = new Random();
//        StringBuffer sb = new StringBuffer();
//        for (int i = 0; i < length; i++) {
//            int number = random.nextInt(base.length());
//            sb.append(base.charAt(number));
//        }
//        return sb.toString();
//    }
//
//    /**
//     * 申请退款
//     */
//    @GetMapping("/refundOrder")
//    public String refundOrder() {
//
//        log.info("根据订单号申请退款，订单号： {}", "要退款的订单号  这里写死");
//        // 退款请求路径
//        String url = "https://api.mch.weixin.qq.com/v3/refund/domestic/refunds";
//        // 设置参数
//        Map<String, Object> params = new HashMap<>(2);
//        // 要退款的订单编号订单编号
//        params.put("out_trade_no", "57984wera64");
//        // 商户自定义退款记录单号 用于退款记录的单号 跟退款订单号不是一样的
//        int outRefundNo = new Random().nextInt(999999999);
//        log.info("退款申请号：{}", outRefundNo);
//        params.put("out_refund_no", outRefundNo + "");
//        // 退款原因
//        params.put("reason", "申请退款");
//        // 退款通知回调地址
//        params.put("notify_url", wechatPayConfig.getRefundNotifyUrl());
//
//        Map<String, Object> amountMap = new HashMap<>();
//        //退款金额，单位：分
//        amountMap.put("refund", 999999);
//        //原订单金额，单位：分
//        amountMap.put("total", 99999);
//        //退款币种
//        amountMap.put("currency", "CNY");
//        params.put("amount", amountMap);
//        String paramsStr = JSON.toJSONString(params);
//        // todo 插入一条退款记录到数据库
//        log.info("请求参数 ===> {}" + paramsStr);
//        String res = wechatPayRequest.wechatHttpPost(url, paramsStr);
//        log.info("退款结果：{}", res);
//        return res;
//    }
//
//}