package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.service.IWaterUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 用户Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/waterUser")
public class WaterUserController extends BaseController
{
    @Autowired
    private IWaterUserService waterUserService;

    /**
     * 查询用户列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterUser waterUser)
    {
        startPage();
        List<WaterUser> list = waterUserService.selectWaterUserList(waterUser);
        return getDataTable(list);
    }

    /**
     * 导出用户列表
     */
    @Log(title = "用户", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterUser waterUser)
    {
        List<WaterUser> list = waterUserService.selectWaterUserList(waterUser);
        ExcelUtil<WaterUser> util = new ExcelUtil<WaterUser>(WaterUser.class);
        util.exportExcel(response, list, "用户数据");
    }

    /**
     * 获取用户详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterUserService.selectWaterUserById(id));
    }

    /**
     * 新增用户
     */
    @Log(title = "用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterUser waterUser)
    {
        return toAjax(waterUserService.insertWaterUser(waterUser));
    }

    /**
     * 修改用户
     */
    @Log(title = "用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterUser waterUser)
    {
        return toAjax(waterUserService.updateWaterUser(waterUser));
    }

    /**
     * 删除用户
     */
    @Log(title = "用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterUserService.deleteWaterUserByIds(ids));
    }


    /**
     * 首页统计数量
     * @return
     */
    @GetMapping("/getUserSl")
    public AjaxResult getUserSl()
    {
        return AjaxResult.success(waterUserService.getUserSl());
    }

    /**
     * 查询用户是否可以记账
     * @return
     */
    @GetMapping("/getSfjz")
    public AjaxResult getSfjz(WaterUser waterUser)
    {
        return AjaxResult.success(waterUserService.getSfjz(waterUser));
    }
}
