package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterUserAddress;
import com.qianhe.system.service.IWaterUserAddressService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 用户地址Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/address")
public class WaterUserAddressController extends BaseController
{
    @Autowired
    private IWaterUserAddressService waterUserAddressService;

    /**
     * 查询用户地址列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterUserAddress waterUserAddress)
    {
        List<WaterUserAddress> list = waterUserAddressService.selectWaterUserAddressList(waterUserAddress);
        return getDataTable(list);
    }

    /**
     * 导出用户地址列表
     */
    @Log(title = "用户地址", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterUserAddress waterUserAddress)
    {
        List<WaterUserAddress> list = waterUserAddressService.selectWaterUserAddressList(waterUserAddress);
        ExcelUtil<WaterUserAddress> util = new ExcelUtil<WaterUserAddress>(WaterUserAddress.class);
        util.exportExcel(response, list, "用户地址数据");
    }

    /**
     * 获取用户地址详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterUserAddressService.selectWaterUserAddressById(id));
    }

    /**
     * 获取用户默认地址
     */
    @GetMapping("/getUserDefaultAddress")
    public AjaxResult getUserDefaultAddress(Long userId){
        return success(waterUserAddressService.getUserDefaultAddress(userId));
    }

    /**
     * 新增用户地址
     */
    @Log(title = "用户地址", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterUserAddress waterUserAddress)
    {
        return toAjax(waterUserAddressService.insertWaterUserAddress(waterUserAddress));
    }

    /**
     * 修改用户地址
     */
    @Log(title = "用户地址", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterUserAddress waterUserAddress)
    {
        return toAjax(waterUserAddressService.updateWaterUserAddress(waterUserAddress));
    }

    /**
     * 删除用户地址
     */
    @Log(title = "用户地址", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterUserAddressService.deleteWaterUserAddressByIds(ids));
    }

    /**
     * 修改用户默认地址
     */
    @PostMapping("/updateDefaultAddress")
    public AjaxResult updateDefaultAddress(@RequestBody WaterUserAddress waterUserAddress){
        return toAjax(waterUserAddressService.updateDefaultAddress(waterUserAddress));
    }
}
