package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterText;
import com.qianhe.system.service.IWaterTextService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 通知公告文本Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/text")
public class WaterTextController extends BaseController
{
    @Autowired
    private IWaterTextService waterTextService;

    /**
     * 查询通知公告文本列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterText waterText)
    {
        startPage();
        List<WaterText> list = waterTextService.selectWaterTextList(waterText);
        return getDataTable(list);
    }

    /**
     * 查询通知公告文本列表(订水端)
     */
    @GetMapping("/listDs")
    public TableDataInfo listDs(WaterText waterText)
    {
        List<WaterText> list = waterTextService.selectWaterTextList(waterText);
        return getDataTable(list);
    }

    /**
     * 导出通知公告文本列表
     */
    @Log(title = "通知公告文本", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterText waterText)
    {
        List<WaterText> list = waterTextService.selectWaterTextList(waterText);
        ExcelUtil<WaterText> util = new ExcelUtil<WaterText>(WaterText.class);
        util.exportExcel(response, list, "通知公告文本数据");
    }

    /**
     * 获取通知公告文本详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterTextService.selectWaterTextById(id));
    }

    /**
     * 新增通知公告文本
     */
    @Log(title = "通知公告文本", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterText waterText)
    {
        return toAjax(waterTextService.insertWaterText(waterText));
    }

    /**
     * 修改通知公告文本
     */
    @Log(title = "通知公告文本", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterText waterText)
    {
        return toAjax(waterTextService.updateWaterText(waterText));
    }

    /**
     * 删除通知公告文本
     */
    @Log(title = "通知公告文本", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterTextService.deleteWaterTextByIds(ids));
    }
}
