package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.system.domain.WaterGoods;
import com.qianhe.system.domain.WaterStock;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.service.IWaterStockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author yc
 * @version 1.0
 * @className WaterStockController
 * @date 2024/3/22 8:34
 * @description
 */
@RestController
@RequestMapping("/system/stock")
public class WaterStockController extends BaseController {
    @Autowired
    private IWaterStockService stockService;

    @PostMapping("/list")
    public TableDataInfo list(@RequestBody WaterStock stock){
        startPage();
        List<WaterStock> list = stockService.list(stock);
        return getDataTable(list);
    }


    @PostMapping("/add")
    public AjaxResult add(@RequestBody WaterStock stock){
        return toAjax(stockService.insertStock(stock));
    }


    @PostMapping("/edit")
    public AjaxResult edit(@RequestBody WaterStock stock){
        return toAjax(stockService.updateStock(stock));
    }

    @PostMapping("/delete")
    public AjaxResult delete(@RequestBody WaterStock stock){
        return toAjax(stockService.deleteStock(stock));
    }

    @GetMapping("/goodsList")
    public TableDataInfo goodsList(){
        startPage();
        List<WaterStock> list = stockService.goodsList();
        return getDataTable(list);
    }

    @PostMapping("/speList")
    public TableDataInfo speList(@RequestBody WaterStock stock){
        startPage();
        List<WaterStock> list = stockService.speList(stock);
        return getDataTable(list);
    }

    @GetMapping("/stationList")
    public TableDataInfo stationList(){
        startPage();
        List<WaterStock> list = stockService.stationList();
        return getDataTable(list);
    }


}