package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterStationUser;
import com.qianhe.system.service.IWaterStationUserService;
import com.qianhe.system.vo.WaterStationUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 站点用户Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/stationUser")
public class WaterStationUserController extends BaseController
{
    @Autowired
    private IWaterStationUserService waterStationUserService;

    /**
     * 查询站点用户列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterStationUser waterStationUser)
    {
        startPage();
        List<WaterStationUserVo> list = waterStationUserService.selectWaterStationUserList(waterStationUser);
        return getDataTable(list);
    }

    /**
     * 导出站点用户列表
     */
    @Log(title = "站点用户", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterStationUser waterStationUser)
    {
        List<WaterStationUserVo> list = waterStationUserService.selectWaterStationUserList(waterStationUser);
        ExcelUtil<WaterStationUserVo> util = new ExcelUtil<WaterStationUserVo>(WaterStationUserVo.class);
        util.exportExcel(response, list, "站点用户数据");
    }

    /**
     * 获取站点用户详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterStationUserService.selectWaterStationUserById(id));
    }

    /**
     * 新增站点用户
     */
    @Log(title = "站点用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterStationUser waterStationUser)
    {
        return toAjax(waterStationUserService.insertWaterStationUser(waterStationUser));
    }

    /**
     * 修改站点用户
     */
    @Log(title = "站点用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterStationUser waterStationUser)
    {
        return toAjax(waterStationUserService.updateWaterStationUser(waterStationUser));
    }

    /**
     * 删除站点用户
     */
    @Log(title = "站点用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterStationUserService.deleteWaterStationUserByIds(ids));
    }
}
