package com.qianhe.system.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.system.domain.WaterStationRegion;
import com.qianhe.system.service.IWaterStationRegionService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 站点区域范围Controller
 *
 * @author qianhe
 * @date 2024-04-15
 */
@RestController
@RequestMapping("/system/waterStationRegion")
public class WaterStationRegionController extends BaseController
{
    @Autowired
    private IWaterStationRegionService waterStationRegionService;

    /**
     * 查询站点区域范围列表
     */
    @PreAuthorize("@ss.hasPermi('system:waterStationRegion:list')")
    @GetMapping("/list")
    public TableDataInfo list(WaterStationRegion waterStationRegion)
    {
        startPage();
        List<WaterStationRegion> list = waterStationRegionService.selectWaterStationRegionList(waterStationRegion);
        return getDataTable(list);
    }

    /**
     * 导出站点区域范围列表
     */
    @PreAuthorize("@ss.hasPermi('system:waterStationRegion:export')")
    @Log(title = "站点区域范围", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterStationRegion waterStationRegion)
    {
        List<WaterStationRegion> list = waterStationRegionService.selectWaterStationRegionList(waterStationRegion);
        ExcelUtil<WaterStationRegion> util = new ExcelUtil<WaterStationRegion>(WaterStationRegion.class);
        util.exportExcel(response, list, "站点区域范围数据");
    }

    /**
     * 获取站点区域范围详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:waterStationRegion:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(waterStationRegionService.selectWaterStationRegionByID(ID));
    }

    /**
     * 新增站点区域范围
     */
    @PreAuthorize("@ss.hasPermi('system:waterStationRegion:add')")
    @Log(title = "站点区域范围", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterStationRegion waterStationRegion)
    {
        return toAjax(waterStationRegionService.insertWaterStationRegion(waterStationRegion));
    }

    /**
     * 修改站点区域范围
     */
    @PreAuthorize("@ss.hasPermi('system:waterStationRegion:edit')")
    @Log(title = "站点区域范围", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterStationRegion waterStationRegion)
    {
        return toAjax(waterStationRegionService.updateWaterStationRegion(waterStationRegion));
    }

    /**
     * 删除站点区域范围
     */
    @PreAuthorize("@ss.hasPermi('system:waterStationRegion:remove')")
    @Log(title = "站点区域范围", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(waterStationRegionService.deleteWaterStationRegionByIDs(IDs));
    }
}
