package com.qianhe.system.controller;

import com.github.pagehelper.PageInfo;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterStation;
import com.qianhe.system.domain.WaterStationUser;
import com.qianhe.system.service.IWaterStationService;
import com.qianhe.system.service.IWaterStationUserService;
import com.qianhe.system.vo.WaterStationUserVo;
import com.qianhe.system.vo.WaterStationVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 站点Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/station")
public class WaterStationController extends BaseController
{
    @Autowired
    private IWaterStationService waterStationService;
    @Autowired
    private IWaterStationUserService waterStationUserService;

    /**
     * 查询站点列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterStation waterStation)
    {
        startPage();
        List<WaterStation> waterStations = waterStationService.selectWaterStationList(waterStation);

        List<WaterStationVo> waterStationVoList = new ArrayList<>();
        //送水工列表
        List<WaterStationUserVo> waterStationUsers = waterStationUserService.selectWaterStationUserList(new WaterStationUser());

        for (WaterStation station : waterStations) {
            //送水工集合
            List<WaterStationUserVo> waterStationUserList = new ArrayList<>();
            //转vo
            WaterStationVo waterStationVo = new WaterStationVo();
            BeanUtils.copyProperties(station,waterStationVo);
            for (WaterStationUserVo waterStationUser : waterStationUsers) {
                if (station.getId().equals(waterStationUser.getStationId())){
                    waterStationUserList.add(waterStationUser);
                }
            }
            if(waterStationUserList.size() > 0){
                waterStationVo.setWaterStationUserList(waterStationUserList);
            }
            waterStationVoList.add(waterStationVo);
        }
        TableDataInfo tableDataInfo = getDataTable(waterStationVoList);
        tableDataInfo.setTotal(new PageInfo(waterStations).getTotal());
        return tableDataInfo;
    }

    /**
     * 导出站点列表
     */
    @Log(title = "站点", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterStation waterStation)
    {
        List<WaterStation> list = waterStationService.selectWaterStationList(waterStation);
        ExcelUtil<WaterStation> util = new ExcelUtil<WaterStation>(WaterStation.class);
        util.exportExcel(response, list, "站点数据");
    }

    /**
     * 获取站点详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterStationService.selectWaterStationById(id));
    }

    /**
     * 新增站点
     */
    @Log(title = "站点", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterStation waterStation)
    {
        return toAjax(waterStationService.insertWaterStation(waterStation));
    }

    /**
     * 修改站点
     */
    @Log(title = "站点", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterStation waterStation)
    {
        return toAjax(waterStationService.updateWaterStation(waterStation));
    }

    /**
     * 修改站点是否营业
     */
    @Log(title = "站点", businessType = BusinessType.UPDATE)
    @PutMapping("/updateIsOpen")
    public AjaxResult updateIsOpen(@RequestBody WaterStation waterStation)
    {
        return toAjax(waterStationService.updateIsOpen(waterStation));
    }

    /**
     * 删除站点
     */
    @Log(title = "站点", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterStationService.deleteWaterStationByIds(ids));
    }

    /**
     * 查询站点下拉框(PC端)
     */
    @GetMapping("/getWaterStationList")
    public AjaxResult getWaterStationList(){
        return AjaxResult.success(waterStationService.getWaterStationList());
    }


    /**
     * 查询站点下拉框
     */
    @GetMapping("/getStationList")
    public AjaxResult getStationList(@RequestParam("lon") double lon, @RequestParam("lat") double lat, String stationName){
        return AjaxResult.success(waterStationService.getStationList(lon,lat,stationName));
    }

    /**
     * 获取最近站点信息
     */
    @GetMapping("/getRecentlyStation")
    public AjaxResult getRecentlyStation(@RequestParam("lon") double lon, @RequestParam("lat") double lat){
        WaterStationVo recentlyStation = waterStationService.getRecentlyStation(lon, lat);
        return success(recentlyStation);
    }

    /**
     * 订单页获取最近站点信息
     */
    @GetMapping("/getRecentlyStation1")
    public AjaxResult getRecentlyStation1(@RequestParam("address") String address, @RequestParam("address1") String address1){
        System.out.println("address====================="+address);
        System.out.println("address1+++++++++++++++++++"+address1);
        WaterStationVo recentlyStation = waterStationService.getRecentlyStation1(address, address1);
        return success(recentlyStation);
    }

    /**
     * 订单页获取站点信息
     */
    @GetMapping("/getRecentlyStation2")
    public AjaxResult getRecentlyStation2(@RequestParam("address") String address, @RequestParam("address1") String address1){
        System.out.println("address====================="+address);
        System.out.println("address1+++++++++++++++++++"+address1);
        WaterStationVo recentlyStation = waterStationService.getRecentlyStation2(address, address1);
        return success(recentlyStation);
    }
}
