package com.qianhe.system.controller;

import com.github.pagehelper.PageInfo;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterSpe;
import com.qianhe.system.domain.WaterSpeVal;
import com.qianhe.system.service.IWaterSpeService;
import com.qianhe.system.vo.WaterSpeVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 商品规格Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/spe")
public class WaterSpeController extends BaseController
{
    @Autowired
    private IWaterSpeService waterSpeService;

    /**
     * 查询商品规格列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterSpe waterSpe)
    {
        startPage();
        List<WaterSpe> list = waterSpeService.selectWaterSpeList(waterSpe);
        //返回的列表
        List<WaterSpeVo> waterSpeVoList = new ArrayList<>();
        //商品规格规格值列表
        List<WaterSpeVal> waterSpeVals = waterSpeService.selectWaterSpeValList(new WaterSpeVal());
        for (WaterSpe spe : list) {
            //转vo
            WaterSpeVo waterSpeVo = new WaterSpeVo();
            BeanUtils.copyProperties(spe,waterSpeVo);
            List<WaterSpeVal> waterSpeValList = new ArrayList<>();
            for (WaterSpeVal waterSpeVal : waterSpeVals) {
                if (spe.getId().equals(waterSpeVal.getSpeId())){
                    waterSpeValList.add(waterSpeVal);
                }
            }
            if (waterSpeValList.size() > 0){
                waterSpeVo.setWaterSpeValList(waterSpeValList);
            }
            waterSpeVoList.add(waterSpeVo);
        }
        TableDataInfo tableDataInfo = getDataTable(waterSpeVoList);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }

    /**
     * 查询商品规格下拉框
     */
    @GetMapping("/goodsSpelist")
    public TableDataInfo goodsSpelist(WaterSpe waterSpe)
    {
        List<WaterSpe> list = waterSpeService.selectWaterSpeList(waterSpe);
        //返回的列表
        List<WaterSpeVo> waterSpeVoList = new ArrayList<>();
        //商品规格规格值列表
        List<WaterSpeVal> waterSpeVals = waterSpeService.selectWaterSpeValList(new WaterSpeVal());
        for (WaterSpe spe : list) {
            //转vo
            WaterSpeVo waterSpeVo = new WaterSpeVo();
            BeanUtils.copyProperties(spe,waterSpeVo);
            List<WaterSpeVal> waterSpeValList = new ArrayList<>();
            for (WaterSpeVal waterSpeVal : waterSpeVals) {
                if (spe.getId().equals(waterSpeVal.getSpeId())){
                    waterSpeValList.add(waterSpeVal);
                }
            }
            if (waterSpeValList.size() > 0){
                waterSpeVo.setWaterSpeValList(waterSpeValList);
            }
            waterSpeVoList.add(waterSpeVo);
        }
        return getDataTable(waterSpeVoList);
    }

    /**
     * 导出商品规格列表
     */
    @Log(title = "商品规格", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterSpe waterSpe)
    {
        List<WaterSpe> list = waterSpeService.selectWaterSpeList(waterSpe);
        ExcelUtil<WaterSpe> util = new ExcelUtil<WaterSpe>(WaterSpe.class);
        util.exportExcel(response, list, "商品规格数据");
    }

    /**
     * 获取商品规格详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterSpeService.selectWaterSpeById(id));
    }

    /**
     * 新增商品规格
     */
    @Log(title = "商品规格", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterSpeVo waterSpeVo)
    {
        return toAjax(waterSpeService.insertWaterSpe(waterSpeVo));
    }

    /**
     * 修改商品规格
     */
    @Log(title = "商品规格", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterSpeVo waterSpeVo)
    {
        return toAjax(waterSpeService.updateWaterSpe(waterSpeVo));
    }

    /**
     * 删除商品规格
     */
    @Log(title = "商品规格", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterSpeService.deleteWaterSpeByIds(ids));
    }
}
