package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterOrderLog;
import com.qianhe.system.service.IWaterOrderLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 订单日志Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/log")
public class WaterOrderLogController extends BaseController
{
    @Autowired
    private IWaterOrderLogService waterOrderLogService;

    /**
     * 查询订单日志列表
     */
    @PreAuthorize("@ss.hasPermi('system:log:list')")
    @GetMapping("/list")
    public TableDataInfo list(WaterOrderLog waterOrderLog)
    {
        startPage();
        List<WaterOrderLog> list = waterOrderLogService.selectWaterOrderLogList(waterOrderLog);
        return getDataTable(list);
    }

    /**
     * 导出订单日志列表
     */
    @PreAuthorize("@ss.hasPermi('system:log:export')")
    @Log(title = "订单日志", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterOrderLog waterOrderLog)
    {
        List<WaterOrderLog> list = waterOrderLogService.selectWaterOrderLogList(waterOrderLog);
        ExcelUtil<WaterOrderLog> util = new ExcelUtil<WaterOrderLog>(WaterOrderLog.class);
        util.exportExcel(response, list, "订单日志数据");
    }

    /**
     * 获取订单日志详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:log:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterOrderLogService.selectWaterOrderLogById(id));
    }

    /**
     * 新增订单日志
     */
    @PreAuthorize("@ss.hasPermi('system:log:add')")
    @Log(title = "订单日志", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterOrderLog waterOrderLog)
    {
        return toAjax(waterOrderLogService.insertWaterOrderLog(waterOrderLog));
    }

    /**
     * 修改订单日志
     */
    @PreAuthorize("@ss.hasPermi('system:log:edit')")
    @Log(title = "订单日志", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterOrderLog waterOrderLog)
    {
        return toAjax(waterOrderLogService.updateWaterOrderLog(waterOrderLog));
    }

    /**
     * 删除订单日志
     */
    @PreAuthorize("@ss.hasPermi('system:log:remove')")
    @Log(title = "订单日志", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterOrderLogService.deleteWaterOrderLogByIds(ids));
    }
}
