package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterOrderGoods;
import com.qianhe.system.service.IWaterOrderGoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 订单商品Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/orderGoods")
public class WaterOrderGoodsController extends BaseController
{
    @Autowired
    private IWaterOrderGoodsService waterOrderGoodsService;

    /**
     * 查询订单商品列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterOrderGoods waterOrderGoods)
    {
        startPage();
        List<WaterOrderGoods> list = waterOrderGoodsService.selectWaterOrderGoodsList(waterOrderGoods);
        return getDataTable(list);
    }

    /**
     * 导出订单商品列表
     */
    @Log(title = "订单商品", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterOrderGoods waterOrderGoods)
    {
        List<WaterOrderGoods> list = waterOrderGoodsService.selectWaterOrderGoodsList(waterOrderGoods);
        ExcelUtil<WaterOrderGoods> util = new ExcelUtil<WaterOrderGoods>(WaterOrderGoods.class);
        util.exportExcel(response, list, "订单商品数据");
    }

    /**
     * 获取订单商品详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterOrderGoodsService.selectWaterOrderGoodsById(id));
    }

    /**
     * 新增订单商品
     */
    @Log(title = "订单商品", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterOrderGoods waterOrderGoods)
    {
        return toAjax(waterOrderGoodsService.insertWaterOrderGoods(waterOrderGoods));
    }

    /**
     * 修改订单商品
     */
    @Log(title = "订单商品", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterOrderGoods waterOrderGoods)
    {
        return toAjax(waterOrderGoodsService.updateWaterOrderGoods(waterOrderGoods));
    }

    /**
     * 删除订单商品
     */
    @Log(title = "订单商品", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterOrderGoodsService.deleteWaterOrderGoodsByIds(ids));
    }
}
