package com.qianhe.system.controller;

import com.github.pagehelper.PageInfo;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.annotation.RepeatSubmit;
import com.qianhe.common.constant.HttpStatus;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.domain.WaterOrder;
import com.qianhe.system.domain.WaterOrderGoods;
import com.qianhe.system.service.IWaterGoodsImgService;
import com.qianhe.system.service.IWaterOrderGoodsService;
import com.qianhe.system.service.IWaterOrderService;
import com.qianhe.system.vo.WaterOrderVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

/**
 * 订单Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/order")
public class WaterOrderController extends BaseController
{
    @Autowired
    private IWaterOrderService waterOrderService;
    @Autowired
    private IWaterOrderGoodsService waterOrderGoodsService;
    @Autowired
    private IWaterGoodsImgService waterGoodsImgService;

    /**
     * 查询订单列表(管理端)
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterOrderVo waterOrderVo)
    {
        startPage();
        List<WaterOrder> list = waterOrderService.selectWaterOrderList(waterOrderVo);
        //返回的订单列表
        List<WaterOrderVo> waterOrderVoList = new ArrayList<>();
        //查询所有订单商品
        List<WaterOrderGoods> waterOrderGoods = waterOrderGoodsService.selectWaterOrderGoodsList(new WaterOrderGoods());
        if (list.size() > 0){
            for (WaterOrder order : list) {
                for (WaterOrderGoods waterOrderGood : waterOrderGoods) {
                    //转vo
                    WaterOrderVo waterOrderVo1 = new WaterOrderVo();
                    BeanUtils.copyProperties(order,waterOrderVo1);
                    if (waterOrderGood.getOrderId().equals(order.getId())){
                        waterOrderVo1.setWaterOrderGoods(waterOrderGood);
                        waterOrderVoList.add(waterOrderVo1);
                    }
                }
            }
        }
        for (WaterOrder waterOrder : list) {
            boolean b = waterOrderVoList.stream().anyMatch(w -> w.getId().equals(waterOrder.getId()));
            if (!b) {
                //转vo
                WaterOrderVo waterOrderVo1 = new WaterOrderVo();
                BeanUtils.copyProperties(waterOrder,waterOrderVo1);
                waterOrderVoList.add(waterOrderVo1);
            }
        }
//        List<WaterOrderVo> waterOrderVoList1 = waterOrderVoList.stream().collect(Collectors.collectingAndThen(
//                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(WaterOrderVo::getId))),
//                ArrayList::new));
//        //根据创建时间倒序排序
//        List<WaterOrderVo> waterOrderVos = waterOrderVoList1.stream().sorted(Comparator.comparing(WaterOrderVo::getCreateTime).reversed()).collect(Collectors.toList());
//        int i = 0;
//        for (WaterOrderVo orderVo : waterOrderVos) {
//            i ++;
//            for (WaterOrderVo vo : waterOrderVoList) {
//                if (orderVo.getId().equals(vo.getId())){
//                    vo.setXh(i);
//                }
//            }
//        }
        TableDataInfo tableDataInfo = getDataTable(waterOrderVoList);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }

    /**
     * 查询用户个人订单列表
     */
    @GetMapping("/listGr")
    public TableDataInfo listGr(WaterOrderVo waterOrderVo)
    {
        //返回的订单列表
        List<WaterOrderVo> waterOrderVoList = new ArrayList<>();
        List<WaterOrder> list = waterOrderService.selectWaterOrderList(waterOrderVo);
        waterOrderVo.setPageNum(null);
        List<WaterOrder> list1 = waterOrderService.selectWaterOrderList(waterOrderVo);
        //查询所有订单商品
        List<WaterOrderGoods> waterOrderGoods = waterOrderGoodsService.selectWaterOrderGoodsList(new WaterOrderGoods());
        //查询所有商品图片
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgService.selectWaterGoodsImgList(new WaterGoodsImg());
        if (list.size() > 0){
            for (WaterOrder order : list) {
                //转vo
                WaterOrderVo waterOrderVo1 = new WaterOrderVo();
                BeanUtils.copyProperties(order,waterOrderVo1);
                List<WaterOrderGoods> waterOrderGoodsList = new ArrayList<>();
                for (WaterOrderGoods waterOrderGood : waterOrderGoods) {
                    if (order.getId().equals(waterOrderGood.getOrderId())){
//                        waterOrderGoodsList.add(waterOrderGood);
                        //封面图集合
                        List<WaterGoodsImg> coverImgs = new ArrayList<>();
                        //详情图集合
                        List<WaterGoodsImg> detailsImgs = new ArrayList<>();
                        for (WaterGoodsImg waterGoodsImg : waterGoodsImgs) {
                            if (waterOrderGood.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                                coverImgs.add(waterGoodsImg);
                            }else if (waterOrderGood.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                                detailsImgs.add(waterGoodsImg);
                            }
                        }
                        if (coverImgs.size() > 0){
                            waterOrderGood.setCoverImgs(coverImgs);
                        }
                        if (detailsImgs.size() > 0){
                            waterOrderGood.setDetailsImgs(detailsImgs);
                        }
                        waterOrderGoodsList.add(waterOrderGood);
//                        waterOrderVo1.setWaterOrderGoods(waterOrderGood);
//                        waterOrderVoList.add(waterOrderVo1);
                    }
                }
                if (waterOrderGoodsList.size() > 0){
                    waterOrderVo1.setWaterOrderGoodsList(waterOrderGoodsList);
                }
                waterOrderVoList.add(waterOrderVo1);
            }
        }
        TableDataInfo dataInfo = new TableDataInfo();
        dataInfo.setRows(waterOrderVoList);
        dataInfo.setCode(HttpStatus.SUCCESS);
        dataInfo.setMsg("查询成果");
        dataInfo.setTotal(list1.size());
        return dataInfo;
    }

    /**
     * 查询用户订单数量
     */
    @GetMapping("/getOrderNumByUser/{userId}")
    public AjaxResult getOrderNumByUser(@PathVariable("userId") Long userId){
        return success(waterOrderService.getOrderNumByUser(userId));
    }

    /**
     * 导出订单列表
     */
    @Log(title = "订单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterOrderVo waterOrderVo)
    {
        List<WaterOrder> list = waterOrderService.selectWaterOrderList(waterOrderVo);
        //返回的订单列表
        List<WaterOrderVo> waterOrderVoList = new ArrayList<>();
        //查询所有订单商品
        List<WaterOrderGoods> waterOrderGoods = waterOrderGoodsService.selectWaterOrderGoodsList(new WaterOrderGoods());
        if (list.size() > 0){
            for (WaterOrder order : list) {
                //转vo
                WaterOrderVo waterOrderVo1 = new WaterOrderVo();
                BeanUtils.copyProperties(order,waterOrderVo1);
                List<WaterOrderGoods> waterOrderGoodsList = new ArrayList<>();
                for (WaterOrderGoods waterOrderGood : waterOrderGoods) {
                    if (order.getId().equals(waterOrderGood.getOrderId())){
                        waterOrderGoodsList.add(waterOrderGood);
                    }
                }
                if (waterOrderGoodsList.size() > 0){
                    waterOrderVo1.setWaterOrderGoodsList(waterOrderGoodsList);
                }
                waterOrderVoList.add(waterOrderVo1);
            }
        }
        ExcelUtil<WaterOrderVo> util = new ExcelUtil<WaterOrderVo>(WaterOrderVo.class);
        util.exportExcel(response, waterOrderVoList, "订单数据");
    }

    /**
     * 获取订单详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterOrderService.selectWaterOrderById(id));
    }

    /**
     * 新增订单
     */
    @Log(title = "订单", businessType = BusinessType.INSERT)
    @PostMapping
    @RepeatSubmit(message = "订单已提交,请勿重复操作!")
    public AjaxResult add(@RequestBody WaterOrderVo waterOrderVo)
    {
        String ddh = waterOrderService.insertWaterOrder(waterOrderVo);
        return success(ddh);
    }

    /**
     * 修改订单
     */
    @Log(title = "订单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterOrderVo waterOrderVo)
    {
        return toAjax(waterOrderService.updateWaterOrder(waterOrderVo));
    }

    /**
     * 删除订单
     */
    @Log(title = "订单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterOrderService.deleteWaterOrderByIds(ids));
    }

    /**
     * 修改订单状态
     */
    @PostMapping("/updateOrderState")
    @RepeatSubmit(message = "请勿重复操作!")
    public AjaxResult updateOrderState(@RequestBody WaterOrderVo waterOrderVo){
        int i = waterOrderService.updateOrderState(waterOrderVo);
        if(i==3){
            return AjaxResult.success("该订单已超过下单时间的晚上0点，请联系商家退款");
        }else if(i==4){
            return AjaxResult.success("退款失败");
        }else if(i==5){
            return AjaxResult.success("退款成功，请注意查收");
        } else {
            return toAjax(i);
        }


    }

    /**
     * 统计站点订单数量（送水端）
     */
    @GetMapping("/getOrderNumByStation")
    public AjaxResult getOrderNumByStation(Long stationId){
        return success(waterOrderService.getOrderNumByStation(stationId));
    }

    /**
     * 根据站点查询订单(送水端)
     */
    @GetMapping("/getWaterOrderListByStationId")
    public TableDataInfo getWaterOrderListByStationId(WaterOrderVo waterOrderVo){

        List<WaterOrderVo> list = waterOrderService.getWaterOrderListByStationId(waterOrderVo);

        //查询该站点所有订单
        waterOrderVo.setPageNum(null);
        List<WaterOrderVo> list1 = waterOrderService.getWaterOrderListByStationId(waterOrderVo);
        //查询所有订单商品
        List<WaterOrderGoods> waterOrderGoods = waterOrderGoodsService.selectWaterOrderGoodsList(new WaterOrderGoods());
        //查询所有商品图片
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgService.selectWaterGoodsImgList(new WaterGoodsImg());
        if (list.size() > 0){
            for (WaterOrderVo order : list) {
                if(order.getPayType()!=null){
                    if(1==order.getPayType()){
                        order.setPayTypeName("微信支付");
                    }else if(2==order.getPayType()){
                        order.setPayTypeName("水票");
                    }else if(3==order.getPayType()){
                        order.setPayTypeName("记账");
                    }
                }
                List<WaterOrderGoods> waterOrderGoodsList = new ArrayList<>();
                for (WaterOrderGoods waterOrderGood : waterOrderGoods) {
                    if (order.getId().equals(waterOrderGood.getOrderId())){
                        //封面图集合
                        List<WaterGoodsImg> coverImgs = new ArrayList<>();
                        //详情图集合
                        List<WaterGoodsImg> detailsImgs = new ArrayList<>();

                        for (WaterGoodsImg waterGoodsImg : waterGoodsImgs) {
                            if (waterOrderGood.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                                coverImgs.add(waterGoodsImg);
                            }else if (waterOrderGood.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                                detailsImgs.add(waterGoodsImg);
                            }
                        }
                        if (coverImgs.size() > 0){
                            waterOrderGood.setCoverImgs(coverImgs);
                        }
                        if (detailsImgs.size() > 0){
                            waterOrderGood.setDetailsImgs(detailsImgs);
                        }
                        waterOrderGoodsList.add(waterOrderGood);
//                        waterOrderVo1.setWaterOrderGoods(waterOrderGood);
//                        waterOrderVoList.add(waterOrderVo1);
                    }
                }
                if (waterOrderGoodsList.size() > 0){
                    order.setWaterOrderGoodsList(waterOrderGoodsList);
                }
            }
        }
        TableDataInfo dataInfo = new TableDataInfo();
        dataInfo.setRows(list);
        dataInfo.setCode(HttpStatus.SUCCESS);
        dataInfo.setMsg("查询成果");
        dataInfo.setTotal(list1.size());
        return dataInfo;
    }

    /**
     * 修改订单完成状态（送水端）
     */
    @PostMapping("/updateCompleteState")
    @RepeatSubmit(message = "请勿重复操作!")
    public AjaxResult updateCompleteState(@RequestBody WaterOrderVo waterOrderVo){
        return toAjax(waterOrderService.updateCompleteState(waterOrderVo));
    }

    /**
     * 修改订单确认状态（订水端）
     */
    @PostMapping("/updateConfirmState")
    @RepeatSubmit(message = "请勿重复操作!")
    public AjaxResult updateConfirmState(@RequestBody WaterOrderVo waterOrderVo){
        return toAjax(waterOrderService.updateConfirmState(waterOrderVo));
    }

    /**
     * PC端首页统计订单数量
     */
    @GetMapping("/countMonthOrderNum")
    public AjaxResult countMonthOrderNum(){
        return success(waterOrderService.countOrderNum());
    }

    /**
     * 新增退款订单
     */
    @PostMapping("/addReturnOrder")
    @RepeatSubmit(message = "订单已提交,请勿重复操作!")
    public AjaxResult addReturnOrder(@RequestBody WaterOrderVo waterOrderVo){
        return toAjax(waterOrderService.addReturnOrder(waterOrderVo));
    }

    /**
     * 修改待付款订单状态(订水端)
     */
    @PostMapping("/updateOrderPayType")
    @RepeatSubmit(message = "请勿重复操作!")
    public AjaxResult updateOrderPayType(@RequestBody WaterOrderVo waterOrderVo){
        return toAjax(waterOrderService.updateOrderPayType(waterOrderVo));
    }

    //
    /**
     * 下单完成后发送通知
     */
    @GetMapping("/gzhSend")
    public AjaxResult gzhSend(WaterOrderVo vo){
        return  waterOrderService.gzhSend(vo);
    }
}
