package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterGoodsType;
import com.qianhe.system.service.IWaterGoodsTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 商品分类Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/type")
public class WaterGoodsTypeController extends BaseController
{
    @Autowired
    private IWaterGoodsTypeService waterGoodsTypeService;

    /**
     * 查询商品分类列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterGoodsType waterGoodsType)
    {
        startPage();
        List<WaterGoodsType> list = waterGoodsTypeService.selectWaterGoodsTypeList(waterGoodsType);
        return getDataTable(list);
    }

    /**
     * 导出商品分类列表
     */
    @Log(title = "商品分类", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterGoodsType waterGoodsType)
    {
        List<WaterGoodsType> list = waterGoodsTypeService.selectWaterGoodsTypeList(waterGoodsType);
        ExcelUtil<WaterGoodsType> util = new ExcelUtil<WaterGoodsType>(WaterGoodsType.class);
        util.exportExcel(response, list, "商品分类数据");
    }

    /**
     * 获取商品分类详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterGoodsTypeService.selectWaterGoodsTypeById(id));
    }

    /**
     * 新增商品分类
     */
    @Log(title = "商品分类", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterGoodsType waterGoodsType)
    {
        return toAjax(waterGoodsTypeService.insertWaterGoodsType(waterGoodsType));
    }

    /**
     * 修改商品分类
     */
    @Log(title = "商品分类", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterGoodsType waterGoodsType)
    {
        return toAjax(waterGoodsTypeService.updateWaterGoodsType(waterGoodsType));
    }

    /**
     * 删除商品分类
     */
    @Log(title = "商品分类", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterGoodsTypeService.deleteWaterGoodsTypeByIds(ids));
    }

    /**
     * 获取商品分类下拉框
     */
    @GetMapping("/getGoodsTypeList")
    public AjaxResult getGoodsTypeList(){
        return AjaxResult.success(waterGoodsTypeService.selectWaterGoodsTypeList(new WaterGoodsType()));
    }
}
