package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterGoodsSpe;
import com.qianhe.system.service.IWaterGoodsSpeService;
import com.qianhe.system.vo.WaterGoodsSpeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 商品关联规格Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/goodsSpe")
public class WaterGoodsSpeController extends BaseController
{
    @Autowired
    private IWaterGoodsSpeService waterGoodsSpeService;

    /**
     * 查询商品关联规格列表
     */
    @PreAuthorize("@ss.hasPermi('system:spe:list')")
    @GetMapping("/list")
    public TableDataInfo list(WaterGoodsSpe waterGoodsSpe)
    {
        startPage();
        List<WaterGoodsSpe> list = waterGoodsSpeService.selectWaterGoodsSpeList(waterGoodsSpe);
        return getDataTable(list);
    }

    /**
     * 导出商品关联规格列表
     */
    @PreAuthorize("@ss.hasPermi('system:spe:export')")
    @Log(title = "商品关联规格", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterGoodsSpe waterGoodsSpe)
    {
        List<WaterGoodsSpe> list = waterGoodsSpeService.selectWaterGoodsSpeList(waterGoodsSpe);
        ExcelUtil<WaterGoodsSpe> util = new ExcelUtil<WaterGoodsSpe>(WaterGoodsSpe.class);
        util.exportExcel(response, list, "商品关联规格数据");
    }

    /**
     * 获取商品关联规格详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:spe:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterGoodsSpeService.selectWaterGoodsSpeById(id));
    }

    /**
     * 新增商品关联规格
     */
    @PreAuthorize("@ss.hasPermi('system:spe:add')")
    @Log(title = "商品关联规格", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterGoodsSpeVo waterGoodsSpeVo)
    {
        return toAjax(waterGoodsSpeService.insertWaterGoodsSpe(waterGoodsSpeVo));
    }

    /**
     * 修改商品关联规格
     */
    @PreAuthorize("@ss.hasPermi('system:spe:edit')")
    @Log(title = "商品关联规格", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterGoodsSpeVo waterGoodsSpeVo)
    {
        return toAjax(waterGoodsSpeService.updateWaterGoodsSpe(waterGoodsSpeVo));
    }

    /**
     * 删除商品关联规格
     */
    @PreAuthorize("@ss.hasPermi('system:spe:remove')")
    @Log(title = "商品关联规格", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterGoodsSpeService.deleteWaterGoodsSpeByIds(ids));
    }
}
