package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.service.IWaterGoodsImgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 商品图片Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/img")
public class WaterGoodsImgController extends BaseController
{
    @Autowired
    private IWaterGoodsImgService waterGoodsImgService;

    /**
     * 查询商品图片列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterGoodsImg waterGoodsImg)
    {
        startPage();
        List<WaterGoodsImg> list = waterGoodsImgService.selectWaterGoodsImgList(waterGoodsImg);
        return getDataTable(list);
    }

    /**
     * 导出商品图片列表
     */
    @Log(title = "商品图片", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterGoodsImg waterGoodsImg)
    {
        List<WaterGoodsImg> list = waterGoodsImgService.selectWaterGoodsImgList(waterGoodsImg);
        ExcelUtil<WaterGoodsImg> util = new ExcelUtil<WaterGoodsImg>(WaterGoodsImg.class);
        util.exportExcel(response, list, "商品图片数据");
    }

    /**
     * 获取商品图片详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterGoodsImgService.selectWaterGoodsImgById(id));
    }

    /**
     * 新增商品图片
     */
    @Log(title = "商品图片", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterGoodsImg waterGoodsImg)
    {
        return toAjax(waterGoodsImgService.insertWaterGoodsImg(waterGoodsImg));
    }

    /**
     * 修改商品图片
     */
    @Log(title = "商品图片", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterGoodsImg waterGoodsImg)
    {
        return toAjax(waterGoodsImgService.updateWaterGoodsImg(waterGoodsImg));
    }

    /**
     * 删除商品图片
     */
    @Log(title = "商品图片", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterGoodsImgService.deleteWaterGoodsImgByIds(ids));
    }
}
