package com.qianhe.system.controller;

import com.github.pagehelper.PageInfo;
import com.qianhe.common.annotation.Anonymous;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.system.domain.WaterGoods;
import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.domain.WaterGoodsType;
import com.qianhe.system.domain.WaterStation;
import com.qianhe.system.service.IWaterGoodsImgService;
import com.qianhe.system.service.IWaterGoodsService;
import com.qianhe.system.service.IWaterGoodsTypeService;
import com.qianhe.system.service.IWaterStationService;
import com.qianhe.system.vo.WaterGoodsVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 商品Controller
 *
 * @author qianhe
 * @date 2023-11-23
 */
@RestController
@RequestMapping("/system/goods")
public class WaterGoodsController extends BaseController
{
    @Autowired
    private IWaterGoodsService waterGoodsService;
    @Autowired
    private IWaterGoodsImgService waterGoodsImgService;
    @Autowired
    private IWaterStationService waterStationService;
    @Autowired
    private IWaterGoodsTypeService waterGoodsTypeService;

    /**
     * 查询商品列表
     */
    @GetMapping("/list")
    public TableDataInfo list(WaterGoods waterGoods)
    {
        startPage();
        List<WaterGoods> list = waterGoodsService.selectWaterGoodsList(waterGoods);
        //查询所有商品图片
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgService.selectWaterGoodsImgList(new WaterGoodsImg());
        //查询所有站点
        List<WaterStation> waterStations = waterStationService.selectWaterStationList(new WaterStation());
        //查询所有商品分类
        List<WaterGoodsType> waterGoodsTypes = waterGoodsTypeService.selectWaterGoodsTypeList(new WaterGoodsType());
        List<WaterGoodsVo> waterGoodsVos = new ArrayList<>();
        if (list.size() > 0){
            for (WaterGoods goods : list) {
                //转vo
                WaterGoodsVo waterGoodsVo = new WaterGoodsVo();
                BeanUtils.copyProperties(goods,waterGoodsVo);
                List<WaterGoodsImg> coverImgs = new ArrayList<>();
                List<WaterGoodsImg> detailsImgs = new ArrayList<>();
                for (WaterGoodsImg waterGoodsImg : waterGoodsImgs) {
                    if (goods.getId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                        //商品封面图
                        coverImgs.add(waterGoodsImg);
                    }
                    if (goods.getId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                        //商品详情图
                        detailsImgs.add(waterGoodsImg);
                    }
                }
                if (coverImgs.size() > 0){
                    waterGoodsVo.setCoverImgs(coverImgs);
                }
                if (detailsImgs.size() > 0){
                    waterGoodsVo.setDetailsImgs(detailsImgs);
                }
                //设置站点名称
                if (StringUtils.isNotEmpty(goods.getBelongStationId())){
                    String[] split = goods.getBelongStationId().split(",");
                    String stationName = "";
                    if (split.length > 1){
                        for (int i = 0; i < split.length; i++) {
                            for (WaterStation waterStation : waterStations) {
                                if (split[i].equals(waterStation.getId().toString())){
                                    if (i == split.length - 1){
                                        stationName += waterStation.getStationName();
                                    }else {
                                        stationName += waterStation.getStationName() + ",";
                                    }
                                }
                            }
                        }
                    }else {
                        for (WaterStation waterStation : waterStations) {
                            if (split[0].equals(waterStation.getId().toString())){
                                stationName = waterStation.getStationName();
                            }
                        }
                    }
                    waterGoodsVo.setBelongStationNames(stationName);
                }
                //设置商品分类名称
                if (StringUtils.isNotNull(goods.getGoodsTypeId())){
                    for (WaterGoodsType waterGoodsType : waterGoodsTypes) {
                        if (goods.getGoodsTypeId().equals(waterGoodsType.getId())){
                            waterGoodsVo.setGoodsTypeName(waterGoodsType.getTypeName());
                        }
                    }
                }
                waterGoodsVos.add(waterGoodsVo);
            }
        }
        TableDataInfo tableDataInfo = getDataTable(waterGoodsVos);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }


    /**
     * 查询商品列表
     */
    @GetMapping("/listBytype")
    public TableDataInfo listBytype(WaterGoods waterGoods)
    {
        startPage();
        waterGoods.setStatus(1);
        List<WaterGoods> list = waterGoodsService.selectWaterGoodsList(waterGoods);
        //查询所有商品图片
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgService.selectWaterGoodsImgList(new WaterGoodsImg());
        //查询所有站点
        List<WaterStation> waterStations = waterStationService.selectWaterStationList(new WaterStation());
        //查询所有商品分类
        List<WaterGoodsType> waterGoodsTypes = waterGoodsTypeService.selectWaterGoodsTypeList(new WaterGoodsType());
        List<WaterGoodsVo> waterGoodsVos = new ArrayList<>();
        if (list.size() > 0){
            for (WaterGoods goods : list) {
                //转vo
                WaterGoodsVo waterGoodsVo = new WaterGoodsVo();
                BeanUtils.copyProperties(goods,waterGoodsVo);
                List<WaterGoodsImg> coverImgs = new ArrayList<>();
                List<WaterGoodsImg> detailsImgs = new ArrayList<>();
                for (WaterGoodsImg waterGoodsImg : waterGoodsImgs) {
                    if (goods.getId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                        //商品封面图
                        coverImgs.add(waterGoodsImg);
                    }
                    if (goods.getId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                        //商品详情图
                        detailsImgs.add(waterGoodsImg);
                    }
                }
                if (coverImgs.size() > 0){
                    waterGoodsVo.setCoverImgs(coverImgs);
                }
                if (detailsImgs.size() > 0){
                    waterGoodsVo.setDetailsImgs(detailsImgs);
                }
                //设置站点名称
                if (StringUtils.isNotEmpty(goods.getBelongStationId())){
                    String[] split = goods.getBelongStationId().split(",");
                    String stationName = "";
                    if (split.length > 1){
                        for (int i = 0; i < split.length; i++) {
                            for (WaterStation waterStation : waterStations) {
                                if (split[i].equals(waterStation.getId().toString())){
                                    if (i == split.length - 1){
                                        stationName += waterStation.getStationName();
                                    }else {
                                        stationName += waterStation.getStationName() + ",";
                                    }
                                }
                            }
                        }
                    }else {
                        for (WaterStation waterStation : waterStations) {
                            if (split[0].equals(waterStation.getId().toString())){
                                stationName = waterStation.getStationName();
                            }
                        }
                    }
                    waterGoodsVo.setBelongStationNames(stationName);
                }
                //设置商品分类名称
                if (StringUtils.isNotNull(goods.getGoodsTypeId())){
                    for (WaterGoodsType waterGoodsType : waterGoodsTypes) {
                        if (goods.getGoodsTypeId().equals(waterGoodsType.getId())){
                            waterGoodsVo.setGoodsTypeName(waterGoodsType.getTypeName());
                        }
                    }
                }
                waterGoodsVos.add(waterGoodsVo);
            }
        }
        TableDataInfo tableDataInfo = getDataTable(waterGoodsVos);
        tableDataInfo.setTotal(new PageInfo(list).getTotal());
        return tableDataInfo;
    }

    @GetMapping("/zyImgList")
    public List imgList(){
        return waterGoodsService.selectWaterGoodsList1();
    }

    /**
     * 查询首页商品列表(订水端小程序)
     */
    @GetMapping("/syList")
    public TableDataInfo syList(WaterGoods waterGoods)
    {
        //只看上架的商品
        waterGoods.setStatus(1);
        List<WaterGoods> list = waterGoodsService.selectWaterGoodsList(waterGoods);
        //查询所有商品图片
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgService.selectWaterGoodsImgList(new WaterGoodsImg());
        //查询所有站点
        List<WaterStation> waterStations = waterStationService.selectWaterStationList(new WaterStation());
        //查询所有商品分类
        List<WaterGoodsType> waterGoodsTypes = waterGoodsTypeService.selectWaterGoodsTypeList(new WaterGoodsType());
        List<WaterGoodsVo> waterGoodsVos = new ArrayList<>();
        if (list.size() > 0){
            for (WaterGoods goods : list) {
                //转vo
                WaterGoodsVo waterGoodsVo = new WaterGoodsVo();
                BeanUtils.copyProperties(goods,waterGoodsVo);
                List<WaterGoodsImg> coverImgs = new ArrayList<>();
                List<WaterGoodsImg> detailsImgs = new ArrayList<>();
                for (WaterGoodsImg waterGoodsImg : waterGoodsImgs) {
                    if (goods.getId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                        //商品封面图
                        coverImgs.add(waterGoodsImg);
                    }
                    if (goods.getId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                        //商品详情图
                        detailsImgs.add(waterGoodsImg);
                    }
                }
                if (coverImgs.size() > 0){
                    waterGoodsVo.setCoverImgs(coverImgs);
                }
                if (detailsImgs.size() > 0){
                    waterGoodsVo.setDetailsImgs(detailsImgs);
                }
                //设置站点名称
                if (StringUtils.isNotEmpty(goods.getBelongStationId())){
                    String[] split = goods.getBelongStationId().split(",");
                    String stationName = "";
                    if (split.length > 1){
                        for (int i = 0; i < split.length; i++) {
                            for (WaterStation waterStation : waterStations) {
                                if (split[i].equals(waterStation.getId().toString())){
                                    if (i == split.length - 1){
                                        stationName += waterStation.getStationName();
                                    }else {
                                        stationName += waterStation.getStationName() + ",";
                                    }
                                }
                            }
                        }
                    }else {
                        for (WaterStation waterStation : waterStations) {
                            if (split[0].equals(waterStation.getId().toString())){
                                stationName = waterStation.getStationName();
                            }
                        }
                    }
                    waterGoodsVo.setBelongStationNames(stationName);
                }
                //设置商品分类名称
                if (StringUtils.isNotNull(goods.getGoodsTypeId())){
                    for (WaterGoodsType waterGoodsType : waterGoodsTypes) {
                        if (goods.getGoodsTypeId().equals(waterGoodsType.getId())){
                            waterGoodsVo.setGoodsTypeName(waterGoodsType.getTypeName());
                        }
                    }
                }
                waterGoodsVos.add(waterGoodsVo);
            }
        }
        //按分类查询商品
        List<Map<String,Object>> mapList = new ArrayList<>();
        for (WaterGoodsType waterGoodsType : waterGoodsTypes) {
            if (!waterGoodsType.getTypeName().equals("主页轮播图")){
                Map<String,Object> map = new HashMap<>();
                List<WaterGoodsVo> waterGoodsVoList = new ArrayList<>();
                for (WaterGoodsVo waterGoodsVo : waterGoodsVos) {
                    if (waterGoodsType.getId().equals(waterGoodsVo.getGoodsTypeId())){
                        waterGoodsVoList.add(waterGoodsVo);
                    }
                }
                if(waterGoodsVoList.size()>0){
                    map.put("goodsTypeName",waterGoodsType.getTypeName());
                    map.put("waterGoodsVoList",waterGoodsVoList);
                    mapList.add(map);
                }
            }
        }
        return getDataTable(mapList);
    }

    /**
     * 导出商品列表
     */
    @Log(title = "商品", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WaterGoods waterGoods)
    {
        List<WaterGoods> list = waterGoodsService.selectWaterGoodsList(waterGoods);
        ExcelUtil<WaterGoods> util = new ExcelUtil<WaterGoods>(WaterGoods.class);
        util.exportExcel(response, list, "商品数据");
    }

    /**
     * 获取商品详细信息
     */
    @Anonymous
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(waterGoodsService.selectWaterGoodsById(id));
    }

    /**
     * 新增商品
     */
    @Log(title = "商品", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WaterGoodsVo waterGoodsVo) throws IOException
    {
        return toAjax(waterGoodsService.insertWaterGoods(waterGoodsVo));
    }

    /**
     * 修改商品
     */
    @Log(title = "商品", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WaterGoodsVo waterGoodsVo) throws IOException
    {
        return toAjax(waterGoodsService.updateWaterGoods(waterGoodsVo));
    }

    /**
     * 删除商品
     */
    @Log(title = "商品", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterGoodsService.deleteWaterGoodsByIds(ids));
    }

    /**
     * 点击退款之后的水票信息
     */
    @GetMapping("/getGoodsSp")
    public AjaxResult getGoodsSp(){
        return success(waterGoodsService.getGoodsSp());
    }

    /**
     * 获取选中的商品信息
     * @param waterGoodsVo
     * @return
     */
    @PostMapping("/getGoodsXq")
    public AjaxResult getGoodsXq(@RequestBody WaterGoodsVo waterGoodsVo){
        return success(waterGoodsService.getGoodsXq(waterGoodsVo));
    }


    /**
     * 保存轮播图
     */
    @Log(title = "保存轮播图", businessType = BusinessType.INSERT)
    @PostMapping("/savelbt")
    public AjaxResult savelbt(@RequestBody WaterGoodsImg waterGoodsImg) throws IOException
    {
        return toAjax(waterGoodsService.savelbt(waterGoodsImg));
    }



}
