package com.qianhe.system.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.annotation.RepeatSubmit;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.system.domain.WaterGoodsCart;
import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.domain.WaterGoodsSpe;
import com.qianhe.system.domain.WaterGoodsSpeVal;
import com.qianhe.system.service.IWaterGoodsCartService;
import com.qianhe.system.service.IWaterGoodsImgService;
import com.qianhe.system.service.IWaterGoodsSpeService;
import com.qianhe.system.vo.WaterGoodsCartVo;
import com.qianhe.system.vo.WaterGoodsSpeVo;
import com.qianhe.system.vo.WaterGoodsVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/system/cart")
public class WaterGoodsCartController extends BaseController {

    @Autowired
    private IWaterGoodsCartService waterGoodsCartService;
    @Autowired
    private IWaterGoodsImgService waterGoodsImgService;
    @Autowired
    private IWaterGoodsSpeService waterGoodsSpeService;

    /**
     * 查询购物车列表
     * @param waterGoodsCart
     * @return
     */


    @GetMapping("/list")
    public TableDataInfo list(WaterGoodsCart waterGoodsCart){
        //查询全部商品图片
        List<WaterGoodsImg> waterGoodsImgList = waterGoodsImgService.selectWaterGoodsImgList(new WaterGoodsImg());
        List<WaterGoodsCart> list = waterGoodsCartService.selectWaterGoodsCartList(waterGoodsCart);
        for (WaterGoodsCart goodsCart : list) {
            //封面图集合
            List<WaterGoodsImg> coverImgs = new ArrayList<>();
            //详情图集合
            List<WaterGoodsImg> detailsImgs = new ArrayList<>();
            for (WaterGoodsImg waterGoodsImg : waterGoodsImgList) {
                //封面图
                if (goodsCart.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                    coverImgs.add(waterGoodsImg);
                }else if (goodsCart.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                    detailsImgs.add(waterGoodsImg);
                }
            }
            if (coverImgs.size() > 0){
                goodsCart.setCoverImgs(coverImgs);
            }
            if (detailsImgs.size() > 0){
                goodsCart.setDetailsImgs(detailsImgs);
            }
        }
        return getDataTable(list);
    }

    /**
     * 查看详情
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return success(waterGoodsCartService.selectWaterGoodsCartById(id));
    }

    /**
     * 新增购物车商品
     */
    @PostMapping
    @RepeatSubmit(message = "请勿重复操作!")
    public AjaxResult add(@RequestBody WaterGoodsCart waterGoodsCart)
    {
        return toAjax(waterGoodsCartService.insertWaterGoodsCart(waterGoodsCart));
    }

    /**
     * 修改购物车商品
     */
    @PutMapping
    public AjaxResult edit(@RequestBody WaterGoodsCart WaterGoodsCart)
    {
        return toAjax(waterGoodsCartService.updateWaterGoodsCart(WaterGoodsCart));
    }

    /**
     * 修改购物车商品数量
     */
    @PostMapping("/updateGoods")
    public AjaxResult updateGoods(@RequestBody WaterGoodsCart WaterGoodsCart)
    {
        return toAjax(waterGoodsCartService.updateWaterGoodsCart(WaterGoodsCart));
    }

    /**
     * 删除购物车商品
     */
    @DeleteMapping("/{ids}")
    @RepeatSubmit(message = "请勿重复操作!")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(waterGoodsCartService.deleteWaterGoodsCartByIds(ids));
    }

    /**
     * 购物车去结算按钮
     * @param ids
     * @return
     */
    @GetMapping("/getInfo/{ids}")
    @RepeatSubmit(message = "请勿重复操作!")
    public AjaxResult getWaterGoodsCart(@PathVariable Long[] ids){
        //查询全部商品图片
        List<WaterGoodsImg> waterGoodsImgList = waterGoodsImgService.selectWaterGoodsImgList(new WaterGoodsImg());
        List<WaterGoodsCart> list = waterGoodsCartService.selectWaterGoodsCartByIds(ids);
        List<WaterGoodsCartVo> waterGoodsCartVoList = new ArrayList<>();
        for (WaterGoodsCart goodsCart : list) {

            //转vo
            WaterGoodsCartVo waterGoodsCartVo = new WaterGoodsCartVo();
            BeanUtils.copyProperties(goodsCart,waterGoodsCartVo);

            waterGoodsCartVo.setTitle(goodsCart.getGoodsName());
            waterGoodsCartVo.setPrice(goodsCart.getGoodsPrice());

            //封面图集合
            List<WaterGoodsImg> coverImgs = new ArrayList<>();
            //详情图集合
            List<WaterGoodsImg> detailsImgs = new ArrayList<>();
            for (WaterGoodsImg waterGoodsImg : waterGoodsImgList) {
                //封面图
                if (goodsCart.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                    coverImgs.add(waterGoodsImg);
                }else if (goodsCart.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                    detailsImgs.add(waterGoodsImg);
                }
            }
            if (coverImgs.size() > 0){
                waterGoodsCartVo.setCoverImgs(coverImgs);
            }
            if (detailsImgs.size() > 0){
                waterGoodsCartVo.setDetailsImgs(detailsImgs);
            }
            waterGoodsCartVo.setOrderGoodsType(2);
            waterGoodsCartVoList.add(waterGoodsCartVo);
        }
        return success(waterGoodsCartVoList);
    }
}
