package com.qianhe.system.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qianhe.system.vo.GzhVo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/msg")
public class MessageController {

    @Value("${wxgzh.appId}")
    private String appId;

    @Value("${wxgzh.appSecret}")
    private String appSecret;
    @Value("${wxgzh.access-token-uri}")
    private String accessTokenUri;

    //根据appId、appSecret获取access_token
    public String getAccessToken() {
        String url = accessTokenUri;
        // 利用hutool的http工具类请求获取access_token
//        String result = HttpUtil.get(url);
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("grant_type","client_credential");
        paramMap.put("appid","wxb1da01db0d0feb95");
        paramMap.put("secret","5e7479823d02130a95ee8d868db515b2");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(paramMap);
        String result = HttpRequest.post(url).body(json).execute().body();
        JSONObject jsonObject = JSONUtil.parseObj(result);
        return jsonObject.getStr("access_token");
    }

    //订阅号发送
    @GetMapping("/send")
    public String send(){
        JSONObject body=new JSONObject();
        body.set("touser","orQvH6zD7pj7UG0nkUaYRsrjZ8IY");
        body.set("template_id","zYyUtzBbtAtjOSJcGTJyk4ji16yqzyRByPzvMi7QwHo");
        JSONObject json=new JSONObject();
        json.set("character_string1",new JSONObject().set("value","20200820757539"));
        json.set("phrase2",new JSONObject().set("value", "测试"));
        json.set("amount4",new JSONObject().set("value","16"));
        json.set("thing5",new JSONObject().set("value", "测试订阅通知"));
        json.set("thing6",new JSONObject().set("value","桶装水"));
        body.set("data",json);
        //发送
        String accessToken= getAccessToken();
        String post =  HttpUtil.post("https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=" + accessToken, body.toString());
        return "ok";
    }

    @GetMapping("/getToken")
    public String getToken() {
        String url = accessTokenUri;
        // 利用hutool的http工具类请求获取access_token
//        String result = HttpUtil.get(url);
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("grant_type","client_credential");
        paramMap.put("appid","wxb1da01db0d0feb95");
        paramMap.put("secret","907d7f545d5fd2ba57c08a9d497f353d");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(paramMap);
        String result = HttpRequest.post(url).body(json).execute().body();
        JSONObject jsonObject = JSONUtil.parseObj(result);
        return jsonObject.getStr("access_token");
    }

    public static void main(String[] args) {
        String url = "https://api.weixin.qq.com/cgi-bin/stable_token";
        // 利用hutool的http工具类请求获取access_token
//        String result = HttpUtil.get(url);
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("grant_type","client_credential");
        paramMap.put("appid","wxb1da01db0d0feb95");
        paramMap.put("secret","907d7f545d5fd2ba57c08a9d497f353d");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(paramMap);
        String result = HttpRequest.post(url).body(json).execute().body();
        JSONObject jsonObject = JSONUtil.parseObj(result);
        System.out.println(jsonObject.getStr("access_token"));
    }

    //公众号发送
    @GetMapping("/gzhSend")
    public void gzhSend(){
        JSONObject body=new JSONObject();
        //
        String accessToken= getAccessToken();
        System.out.println("=========================================accessToken"+accessToken);
        //获取标签标签tagid
        String post = HttpUtil.post("https://api.weixin.qq.com/cgi-bin/tags/get?access_token=" + accessToken, body.toString());
        System.out.println("=========================================tag"+post);

        JSONObject jsonObjectTag = JSONUtil.parseObj(post);
        System.out.println("=========================================jsonObjectTag"+jsonObjectTag);
        int tagid=100;
        //获取这个标签下的所有用户
        GzhVo vo=new GzhVo();
        vo.setTagid(tagid);
        String url="https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token=" + accessToken;
        String post1 = HttpUtil.createPost(url)
                .contentType("application/json")
                .body(JSON.toJSONString(vo)).execute().body();
        System.out.println("++++++++++++++++++++++++"+post1);
        JSONObject jsonObject = JSONUtil.parseObj(post1);
        System.out.println("++++++++++++++++++++++++"+jsonObject);
        //发送模板消息

//        String requestUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token="  + accessToken;
////        body.set("touser","oRYXP0xFdoL6y_KfDJqqVrSzWz3M");//姜
//        body.set("touser","oRYXP0yahhI3RuBY2zM5iSnudap8");//王琪
//        body.set("template_id","uHjot1RT24Ws9he-8EVffVHq6hQgqPVTD1Y4w8wRHg8");
//        JSONObject json=new JSONObject();
//        json.set("thing27",new JSONObject().set("value","测试"));
//        json.set("amount24",new JSONObject().set("value", "16"));
//        json.set("time4",new JSONObject().set("value","2024-04-19"));
//        json.set("phone_number8",new JSONObject().set("value", "13325057900"));
//        body.set("data",json);
//        String resp = HttpUtil.post(requestUrl,body.toString());
//        JSONObject result = JSONUtil.parseObj(resp);
//        System.out.println("发送消息:" + resp);
//        System.out.println("发送消息:" + result);
    }
}