package com.qianhe.system.controller;

import com.ccb.CCBMisSdk;
import com.fasterxml.jackson.core.type.TypeReference;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.config.Config;
import com.qianhe.system.domain.CcbKey;
import com.qianhe.system.domain.WaterOrder;
import com.qianhe.system.enums.TransRequestEnum;
import com.qianhe.system.mapper.CcbKeyMapper;
import com.qianhe.system.utils.JsonUtil;
import com.qianhe.system.utils.MisApiUtil;
import com.qianhe.system.utils.RequestService;
import com.qianhe.system.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 建行退款
 */
@RestController
@Slf4j
@RequestMapping("/ccbRefund")
public class CCBRefundController {

    @Value("${wx.shbh}")
    private String shbh;
    @Value("${wx.zdbh}")
    private String zdbh;
    @Autowired
    private CcbKeyMapper ccbKeyMapper;

    @PostMapping("/refund")
    public AjaxResult ccbRefund(WaterOrder waterOrder){
        CcbKey ccbKey=new CcbKey();
        ccbKey.setSfgq("1");
        //第一次根据授权码下载密钥
        CcbKey ccbKey1 = ccbKeyMapper.selectCcbKeyList(ccbKey).stream().findFirst().orElse(null);
        String key = "";
        if(ccbKey1!=null){
            key=ccbKey1.getCcbkey();
        }
        //第一次根据授权码下载密钥
//        String key = Config.key;//密钥更新
//        String key = MisApiUtil.getAu012Key();//密钥更新
//        MisApiUtil.confirmKey(key);;//密钥确认
//        System.out.println("key:"+key);

//        String key="3e9c5f4bc0722270c2caf799ec5c592e";
        if(StringUtils.isEmpty(key)){
            return AjaxResult.error("key获取失败");
        }
        String mchtNo=shbh;//建行15位商户编号（固定）
        String termNo=zdbh;//建行8位终端编号（固定）
        //参数
        String address="山东省东营市东营区北二路37号";//地址
//        String gps="37.470666,118.602392";//GPS地理位置信息
        String amt="0.01";//退款金额
        String orderNo=waterOrder.getOrderNum();//订单号
        String numberId=waterOrder.getTkbh();//退款订单号
        //参数加密
        MisApiHttpVo misApiHttpVo = new MisApiHttpVo(TransRequestEnum.RF001, mchtNo, termNo,"1.2.0");
        TransRequest transResult = new TransRequest(address,null);
        TransData transData = new TransData();
        transData.setAmt(amt);
        transData.setOrderNo(orderNo);
        transData.setNumberId(numberId);
        transResult.setTransData(transData);
        System.out.println("transResult："+JsonUtil.toJsonString(transResult));

        //加密参数
        misApiHttpVo.encodeData(JsonUtil.toJsonString(transResult), key);

        System.out.println("misApiHttpVo："+JsonUtil.toJsonString(misApiHttpVo));

        //发送请求
        String result = new RequestService().sendJsonPost(Config.url, null, JsonUtil.toJsonString(misApiHttpVo));
        System.out.println("result："+result);
        //json转对象
        MisApiResponseVo misApiResponse = JsonUtil.jsonStringToObject(result, new TypeReference<MisApiResponseVo>() {
        });
        if("00".equals(misApiResponse.getRetCode())){
            //解密数据
            String transResultStr = CCBMisSdk.CCBMisSdk_DataDecrypt(misApiResponse.getData(), key);
            System.out.println(transResultStr);
            return AjaxResult.success();
        }else{
            //请求失败
            System.out.println(misApiResponse.getRetErrMsg());
            return AjaxResult.error(misApiResponse.getRetErrMsg());
        }
    }


    @GetMapping("/testKey")
    public void getKey(){
        CcbKey ccbKey=new CcbKey();
        ccbKey.setSfgq("1");
        CcbKey ccbKey1 = ccbKeyMapper.selectCcbKeyList(ccbKey).stream().findFirst().orElse(null);
        String key = "";
        if(ccbKey1!=null){
            key=ccbKey1.getCcbkey();
            System.out.println("old:"+key);
            key= MisApiUtil.getAu012Key(key);//密钥更新
            MisApiUtil.confirmKey(key);;//密钥确认
            System.out.println("new:"+key);
        }else {
            //第一次根据授权码下载密钥
            key=MisApiUtil.getAu011( Config.authCode);
            System.out.println("First:"+key);
        }

        //先把已有的key改为过期状态
        ccbKeyMapper.updateCcbKeySfgq();
        //把最新的保存
        ccbKey.setCcbkey(key);
        System.out.println(ccbKey);
        ccbKeyMapper.insertCcbKey(ccbKey);
    }
}
