package com.qianhe.system.controller;

import cn.hutool.core.util.EscapeUtil;
import com.google.gson.Gson;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.system.domain.WaterGoods;
import com.qianhe.system.utils.MD5;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import static com.qianhe.common.core.domain.AjaxResult.success;

/**
 * @author yc
 * @version 1.0
 * @className BankPay
 * @date 2024/3/26 9:17
 * @description 建行支付
 */
@RestController
@RequestMapping("/ccbPay")
public class CCBPayController {


    String pk = "";

    public static void main(String[] args) {
        System.out.println(EscapeUtil.escape("中文"));
    }

    /**
     * 预支付订单生成入口
     */
    @PostMapping("/pay")
    public AjaxResult bankPay(@RequestBody WaterGoods goods) throws IOException {

        //建行提供
        String MERCHANTID = "105000149005386";
        //建行提供
        String POSID = "081113098";
        //建行提供
        String BRANCHID = "370000000";
        String ORDERID = goods.getOrderNo();
        //支付金额为数字类型
        Double PAYMENT = Double.parseDouble(goods.getTotalPrice());
        String CURCODE = "01";
        String TXCODE = "530590";
        String REMARK1 = "minipay";
        String REMARK2 = "minipay";
        String TYPE = "1";
        //公钥后30位
        String PUB = "c2660ff6f7c5d64570352f21020111";
        String GATEWAY = "0";
        String CLIENTIP = "127.0.0.1";
        String REGINFO = "";
        //中文需要转义
        String PROINFO = goods.getOrderNo();
        String REFERER = "";
        String TRADE_TYPE = "MINIPRO";
        //订水微信小程序appId
        String SUB_APPID = "wx3c0181d9800dfbf2";
        //所属用户微信openId
        String SUB_OPENID = goods.getOpenId();

        String macStr = "MERCHANTID=105000149005386";
        macStr+= "&POSID="+POSID;
        macStr+= "&BRANCHID="+BRANCHID;
        macStr+= "&ORDERID="+ORDERID;
        macStr+= "&PAYMENT="+PAYMENT;
        macStr+= "&CURCODE="+CURCODE;
        macStr+= "&TXCODE="+TXCODE;
        macStr+= "&REMARK1="+REMARK1;
        macStr+= "&REMARK2="+REMARK2;
        macStr+= "&TYPE="+TYPE;
        macStr+= "&PUB="+PUB;
        macStr+= "&GATEWAY="+GATEWAY;
        macStr+= "&CLIENTIP="+CLIENTIP;
        macStr+= "&REGINFO="+REGINFO;
        macStr+= "&PROINFO="+PROINFO;
        macStr+= "&REFERER="+REFERER;
        macStr+= "&TRADE_TYPE="+TRADE_TYPE;
        macStr+= "&SUB_APPID="+SUB_APPID;
        macStr+= "&SUB_OPENID="+SUB_OPENID;
        System.out.println("------------------------------------------------------------------------"+macStr);
        //参与MAC计算所需参数具体看开发文档
        String  macStrMd5 = MD5.EncodeByMD5(macStr);




        String url = "https://ibsbjstar.ccb.com.cn/CCBIS/ccbMain?CCB_IBSVersion=V6";
        url += "&MERCHANTID="+MERCHANTID;
        url += "&POSID="+POSID;
        url += "&BRANCHID="+BRANCHID;
        url += "&ORDERID="+ORDERID;
        url += "&PAYMENT="+PAYMENT;
        url += "&CURCODE="+CURCODE;
        url += "&TXCODE="+TXCODE;
        url += "&REMARK1="+REMARK1;
        url += "&REMARK2="+REMARK2;
        url += "&TYPE="+TYPE;
        url += "&GATEWAY="+GATEWAY;
        url += "&CLIENTIP="+CLIENTIP;
        url += "&REGINFO="+REGINFO;
        url += "&PROINFO="+PROINFO;
        url += "&REFERER="+REFERER;
        url += "&TRADE_TYPE="+TRADE_TYPE;
        url += "&SUB_APPID="+SUB_APPID;
        url += "&SUB_OPENID="+SUB_OPENID;

        url += "&MAC="+macStrMd5;


        CloseableHttpClient httpclient = HttpClients.createDefault();
        //发起第一次支付请求，获取PAYURL
        HttpPost httppost = new HttpPost(url);
        CloseableHttpResponse response = httpclient.execute(httppost);

        String result = "";
        // 将签名时数据和签名一起返回前端用于前端吊起支付
        Map<String, Object> resultMap = new HashMap<>();
        try {
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity);
            EntityUtils.consume(entity);
            System.out.println(result);
            Gson gson = new Gson();
            Map<String, Object> map = new HashMap<String, Object>();
            //解析PAYURL
            map = gson.fromJson(result, map.getClass());
            String success =(String) map.get("SUCCESS");
            String payUrl =(String) map.get("PAYURL");
            System.out.println("payUrl的值为:"+payUrl);
            //发起PAYURL请求
            httppost = new HttpPost(payUrl);
            response = httpclient.execute(httppost);
            entity = response.getEntity();
            String payResult = EntityUtils.toString(entity);
            EntityUtils.consume(entity);
            //解析PAYURL请求
            map = gson.fromJson(payResult, map.getClass());
            String ERRCODE =(String) map.get("ERRCODE");
            System.out.println("ERRCODE的值为:"+ERRCODE);
            System.out.println(payResult);
            if(ERRCODE.equals("000000")){
                String appId = (String) map.get("appId");
                String timeStamp = (String) map.get("timeStamp");
                String nonceStr = (String) map.get("nonceStr");
                String packageS = (String) map.get("package");
                String signType = (String) map.get("signType");
                String paySign = (String) map.get("paySign");
                // 小程序id
                resultMap.put("appId", appId);
                // 时间戳
                resultMap.put("timeStamp", timeStamp);
                // 随机字符串
                resultMap.put("nonceStr", nonceStr);
                // 预支付交易会话ID
                resultMap.put("package", packageS);
                // 签名方式
                resultMap.put("signType", signType);
                // 签名
                resultMap.put("paySign", paySign);
            }
        } finally {
            response.close();
        }
        return  success(resultMap);
    }
}