package com.qianhe.system.controller;

import CCBSign.RSASig;
import com.alibaba.fastjson.JSON;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.domain.CCBNotifyInfo;
import com.qianhe.system.domain.WaterOrderLog;
import com.qianhe.system.mapper.WaterOrderLogMapper;
import com.qianhe.system.mapper.WaterOrderMapper;
import com.qianhe.system.service.IWaterOrderService;
import com.qianhe.system.utils.RSASigUtils;
import com.qianhe.system.vo.WaterOrderVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;


/**
 * @author yc
 * @version 1.0
 * @className CCBBackController
 * @date 2024/3/28 11:00
 * @description 建行回调
 */
@RestController
@Slf4j
@RequestMapping("/ccbback")
public class CCBBackController {

    @Autowired
    private WaterOrderLogMapper orderLogMapper;

    @Autowired
    private WaterOrderMapper orderMapper;
    @Autowired
    private IWaterOrderService orderService;

    @PostMapping("/payNotify/")
    public String pay(CCBNotifyInfo notifyInfo, HttpServletRequest request ) {

        String queryString = request.getQueryString();
        log.info("建行回调通知参数[{}]", queryString);
        //验签
        boolean b = RSASigUtils.verifySigature(queryString);
        if(b){
            if (notifyInfo.getSUCCESS().equals("Y")) {
                // 这里需要调用建行龙支付提供的查询订单接口以保证订单确实支付成功
           /* SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            Date date = sdf.parse(successTime);*/
                WaterOrderLog orderLog = new WaterOrderLog();
                orderLog.setPayNum(notifyInfo.getORDERID());
                orderLog.setPayTime(DateUtils.getNowDate());
                orderLog.setPayMoney(new BigDecimal(notifyInfo.getPAYMENT()));
                orderLog.setBz(queryString);
                int iLog = orderLogMapper.insertWaterOrderLog(orderLog);
                WaterOrderVo orderVo = new WaterOrderVo();
                orderVo.setOrderNum(notifyInfo.getORDERID());
                orderVo.setZfsj(DateUtils.parseDateToStr("yyyy-MM-dd hh:mm:ss",DateUtils.getNowDate()));
                int orderI = orderMapper.updateByOrderNum(orderVo);
                //发送公众号通知
                WaterOrderVo vo=new WaterOrderVo();
                vo.setOrderNum(notifyInfo.getORDERID());
                orderService.gzhSend(vo);
                log.info("验签通过");
                return "SUCCESS";
            } else {

                // 验签失败
                log.info("验签失败");
                return "FAIL";
            }
        }else {
            // 验签失败
            log.info("验签失败");
            return "FAIL";
        }
    }
}