/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.FastByteArrayOutputStream;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final Charset DEFAULT_CHARSET = CharsetUtil.defaultCharset();

    public static File zip(String string) {
        return ZipUtil.zip(string, DEFAULT_CHARSET);
    }

    public static File zip(String string, Charset charset) {
        return ZipUtil.zip(FileUtil.file(string), charset);
    }

    public static File zip(File file) {
        return ZipUtil.zip(file, DEFAULT_CHARSET);
    }

    public static File zip(File file, Charset charset) {
        File file2 = FileUtil.file(file.getParentFile(), FileUtil.mainName(file) + ".zip");
        ZipUtil.zip(file2, charset, false, file);
        return file2;
    }

    public static File zip(String string, String string2) {
        return ZipUtil.zip(string, string2, false);
    }

    public static File zip(String string, String string2, boolean bl) {
        return ZipUtil.zip(string, string2, DEFAULT_CHARSET, bl);
    }

    public static File zip(String string, String string2, Charset charset, boolean bl) {
        File file = FileUtil.file(string);
        File file2 = FileUtil.file(string2);
        ZipUtil.zip(file2, charset, bl, file);
        return file2;
    }

    public static File zip(File file, boolean bl, File ... fileArray) {
        return ZipUtil.zip(file, DEFAULT_CHARSET, bl, fileArray);
    }

    public static File zip(File file, Charset charset, boolean bl, File ... fileArray) {
        return ZipUtil.zip(file, charset, bl, null, fileArray);
    }

    public static File zip(File file, Charset charset, boolean bl, FileFilter fileFilter, File ... fileArray) {
        ZipUtil.validateFiles(file, fileArray);
        try (ZipOutputStream zipOutputStream = ZipUtil.getZipOutputStream(file, charset);){
            ZipUtil.zip((OutputStream)zipOutputStream, charset, bl, fileFilter, fileArray);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return file;
    }

    public static void zip(OutputStream outputStream, Charset charset, boolean bl, FileFilter fileFilter, File ... fileArray) {
        ZipUtil.zip(ZipUtil.getZipOutputStream(outputStream, charset), bl, fileFilter, fileArray);
    }

    public static void zip(ZipOutputStream zipOutputStream, boolean bl, FileFilter fileFilter, File ... fileArray) {
        try {
            for (File file : fileArray) {
                if (null == file) continue;
                String string = file.getCanonicalPath();
                if (file.isFile() || bl) {
                    string = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
                ZipUtil.zip(file, string, zipOutputStream, fileFilter);
                zipOutputStream.flush();
            }
            zipOutputStream.finish();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static File zip(File file, String string, String string2) {
        return ZipUtil.zip(file, string, string2, DEFAULT_CHARSET);
    }

    public static File zip(File file, String string, String string2, Charset charset) {
        return ZipUtil.zip(file, string, IoUtil.toStream(string2, charset), charset);
    }

    public static File zip(File file, String string, InputStream inputStream) {
        return ZipUtil.zip(file, string, inputStream, DEFAULT_CHARSET);
    }

    public static File zip(File file, String string, InputStream inputStream, Charset charset) {
        return ZipUtil.zip(file, new String[]{string}, new InputStream[]{inputStream}, charset);
    }

    public static File zip(File file, String[] stringArray, InputStream[] inputStreamArray) {
        return ZipUtil.zip(file, stringArray, inputStreamArray, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File file, String[] stringArray, InputStream[] inputStreamArray, Charset charset) {
        if (ArrayUtil.isEmpty(stringArray) || ArrayUtil.isEmpty(inputStreamArray)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (stringArray.length != inputStreamArray.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = ZipUtil.getZipOutputStream(file, charset);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ZipUtil.addFile(inputStreamArray[i2], stringArray[i2], zipOutputStream);
            }
        }
        finally {
            IoUtil.close(zipOutputStream);
        }
        return file;
    }

    public static File unzip(String string) {
        return ZipUtil.unzip(string, DEFAULT_CHARSET);
    }

    public static File unzip(String string, Charset charset) {
        return ZipUtil.unzip(FileUtil.file(string), charset);
    }

    public static File unzip(File file) {
        return ZipUtil.unzip(file, DEFAULT_CHARSET);
    }

    public static File unzip(File file, Charset charset) {
        File file2 = FileUtil.file(file.getParentFile(), FileUtil.mainName(file));
        return ZipUtil.unzip(file, file2, charset);
    }

    public static File unzip(String string, String string2) {
        return ZipUtil.unzip(string, string2, DEFAULT_CHARSET);
    }

    public static File unzip(String string, String string2, Charset charset) {
        return ZipUtil.unzip(FileUtil.file(string), FileUtil.mkdir(string2), charset);
    }

    public static File unzip(File file, File file2) {
        return ZipUtil.unzip(file, file2, DEFAULT_CHARSET);
    }

    public static File unzip(File file, File file2, Charset charset) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(file, charset);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return ZipUtil.unzip(zipFile, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(ZipFile zipFile, File file) {
        if (file.exists() && file.isFile()) {
            throw new UtilException("Target path [{}] exist!", file.getAbsolutePath());
        }
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = ZipUtil.buildFile(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                ZipUtil.write(zipFile, zipEntry, file2);
            }
        }
        finally {
            IoUtil.close(zipFile);
        }
        return file;
    }

    public static File unzip(InputStream inputStream, File file, Charset charset) {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipUtil.unzip(new ZipInputStream(inputStream, charset), file);
    }

    public static File unzip(ZipInputStream zipInputStream, File file) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = zipInputStream.getNextEntry())) {
                File file2 = FileUtil.file(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                FileUtil.writeFromStream((InputStream)zipInputStream, file2);
            }
        }
        catch (IOException iOException) {
            throw new UtilException(iOException);
        }
        finally {
            IoUtil.close(zipInputStream);
        }
        return file;
    }

    public static byte[] unzipFileBytes(String string, String string2) {
        return ZipUtil.unzipFileBytes(string, DEFAULT_CHARSET, string2);
    }

    public static byte[] unzipFileBytes(String string, Charset charset, String string2) {
        return ZipUtil.unzipFileBytes(FileUtil.file(string), charset, string2);
    }

    public static byte[] unzipFileBytes(File file, String string) {
        return ZipUtil.unzipFileBytes(file, DEFAULT_CHARSET, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipFileBytes(File file, Charset charset, String string) {
        ZipFile zipFile;
        block6: {
            byte[] byArray;
            block5: {
                zipFile = null;
                try {
                    zipFile = new ZipFile(file, charset);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (zipEntry.isDirectory() || !string.equals(zipEntry.getName())) continue;
                        byArray = IoUtil.readBytes(zipFile.getInputStream(zipEntry));
                        break block5;
                    }
                    break block6;
                }
                catch (IOException iOException) {
                    try {
                        throw new UtilException(iOException);
                    }
                    catch (Throwable throwable) {
                        IoUtil.close(zipFile);
                        throw throwable;
                    }
                }
            }
            IoUtil.close(zipFile);
            return byArray;
        }
        IoUtil.close(zipFile);
        return null;
    }

    public static byte[] gzip(String string, String string2) {
        return ZipUtil.gzip(StrUtil.bytes((CharSequence)string, string2));
    }

    public static byte[] gzip(byte[] byArray) {
        return ZipUtil.gzip(new ByteArrayInputStream(byArray), byArray.length);
    }

    public static byte[] gzip(File file) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtil.getInputStream(file);
            byte[] byArray = ZipUtil.gzip(bufferedInputStream, (int)file.length());
            return byArray;
        }
        finally {
            IoUtil.close(bufferedInputStream);
        }
    }

    public static byte[] gzip(InputStream inputStream) {
        return ZipUtil.gzip(inputStream, 32);
    }

    public static byte[] gzip(InputStream inputStream, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            IoUtil.copy(inputStream, gZIPOutputStream);
        }
        catch (IOException iOException) {
            try {
                throw new UtilException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(gZIPOutputStream);
                throw throwable;
            }
        }
        IoUtil.close(gZIPOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String unGzip(byte[] byArray, String string) {
        return StrUtil.str(ZipUtil.unGzip(byArray), string);
    }

    public static byte[] unGzip(byte[] byArray) {
        return ZipUtil.unGzip(new ByteArrayInputStream(byArray), byArray.length);
    }

    public static byte[] unGzip(InputStream inputStream) {
        return ZipUtil.unGzip(inputStream, 32);
    }

    public static byte[] unGzip(InputStream inputStream, int n2) {
        FastByteArrayOutputStream fastByteArrayOutputStream;
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = inputStream instanceof GZIPInputStream ? (GZIPInputStream)inputStream : new GZIPInputStream(inputStream);
            fastByteArrayOutputStream = new FastByteArrayOutputStream(n2);
            IoUtil.copy(gZIPInputStream, fastByteArrayOutputStream);
        }
        catch (IOException iOException) {
            try {
                throw new UtilException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(gZIPInputStream);
                throw throwable;
            }
        }
        IoUtil.close(gZIPInputStream);
        return fastByteArrayOutputStream.toByteArray();
    }

    public static byte[] zlib(String string, String string2, int n2) {
        return ZipUtil.zlib(StrUtil.bytes((CharSequence)string, string2), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int n2) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtil.getInputStream(file);
            byte[] byArray = ZipUtil.zlib(bufferedInputStream, n2, (int)file.length());
            return byArray;
        }
        finally {
            IoUtil.close(bufferedInputStream);
        }
    }

    public static byte[] zlib(byte[] byArray, int n2) {
        return ZipUtil.zlib(new ByteArrayInputStream(byArray), n2, byArray.length);
    }

    public static byte[] zlib(InputStream inputStream, int n2) {
        return ZipUtil.zlib(inputStream, n2, 32);
    }

    public static byte[] zlib(InputStream inputStream, int n2, int n3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        ZipUtil.deflater(inputStream, byteArrayOutputStream, n2, false);
        return byteArrayOutputStream.toByteArray();
    }

    public static String unZlib(byte[] byArray, String string) {
        return StrUtil.str(ZipUtil.unZlib(byArray), string);
    }

    public static byte[] unZlib(byte[] byArray) {
        return ZipUtil.unZlib(new ByteArrayInputStream(byArray), byArray.length);
    }

    public static byte[] unZlib(InputStream inputStream) {
        return ZipUtil.unZlib(inputStream, 32);
    }

    public static byte[] unZlib(InputStream inputStream, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        ZipUtil.inflater(inputStream, byteArrayOutputStream, false);
        return byteArrayOutputStream.toByteArray();
    }

    public static List listFileNames(ZipFile zipFile, String string) {
        if (StrUtil.isNotBlank(string)) {
            string = StrUtil.addSuffixIfNot(string, "/");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String string2;
            String string3 = zipEntry.getName();
            if (!StrUtil.isEmpty(string) && !string3.startsWith(string) || !StrUtil.isNotEmpty(string2 = StrUtil.removePrefix(string3, string)) || StrUtil.contains((CharSequence)string2, '/')) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static ZipOutputStream getZipOutputStream(File file, Charset charset) {
        return ZipUtil.getZipOutputStream(FileUtil.getOutputStream(file), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream outputStream, Charset charset) {
        if (outputStream instanceof ZipOutputStream) {
            return (ZipOutputStream)outputStream;
        }
        return new ZipOutputStream(outputStream, (Charset)ObjectUtil.defaultIfNull(charset, DEFAULT_CHARSET));
    }

    private static void zip(File file, String string, ZipOutputStream zipOutputStream, FileFilter fileFilter) {
        if (null == file || null != fileFilter && !fileFilter.accept(file)) {
            return;
        }
        String string2 = FileUtil.subPath(string, file);
        if (file.isDirectory()) {
            Object[] objectArray = file.listFiles();
            if (ArrayUtil.isEmpty(objectArray) && StrUtil.isNotEmpty(string2)) {
                ZipUtil.addDir(string2, zipOutputStream);
            }
            for (Object object : objectArray) {
                ZipUtil.zip((File)object, string, zipOutputStream, fileFilter);
            }
        } else {
            ZipUtil.addFile(file, string2, zipOutputStream);
        }
    }

    private static void addFile(File file, String string, ZipOutputStream zipOutputStream) {
        ZipUtil.addFile(FileUtil.getInputStream(file), string, zipOutputStream);
    }

    private static void addFile(InputStream inputStream, String string, ZipOutputStream zipOutputStream) {
        if (null == inputStream) {
            return;
        }
        try {
            zipOutputStream.putNextEntry(new ZipEntry(string));
            IoUtil.copy(inputStream, zipOutputStream);
        }
        catch (IOException iOException) {
            throw new UtilException(iOException);
        }
        finally {
            IoUtil.close(inputStream);
            ZipUtil.closeEntry(zipOutputStream);
        }
    }

    private static void addDir(String string, ZipOutputStream zipOutputStream) {
        string = StrUtil.addSuffixIfNot(string, "/");
        try {
            zipOutputStream.putNextEntry(new ZipEntry(string));
        }
        catch (IOException iOException) {
            throw new UtilException(iOException);
        }
        finally {
            ZipUtil.closeEntry(zipOutputStream);
        }
    }

    private static void validateFiles(File file, File ... fileArray) {
        if (file.isDirectory()) {
            throw new UtilException("Zip file [{}] must not be a directory !", file.getAbsoluteFile());
        }
        for (File file2 : fileArray) {
            if (null == file2) continue;
            if (!file2.exists()) {
                throw new UtilException(StrUtil.format((CharSequence)"File [{}] not exist!", file2.getAbsolutePath()));
            }
            try {
                File file3 = file.getCanonicalFile().getParentFile();
                if (!file2.isDirectory() || !file3.getCanonicalPath().contains(file2.getCanonicalPath())) continue;
                throw new UtilException("Zip file path [{}] must not be the child directory of [{}] !", file.getCanonicalPath(), file2.getCanonicalPath());
            }
            catch (IOException iOException) {
                throw new UtilException(iOException);
            }
        }
    }

    private static void closeEntry(ZipOutputStream zipOutputStream) {
        try {
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void write(ZipFile zipFile, ZipEntry zipEntry, File file) {
        InputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipEntry);
            FileUtil.writeFromStream(inputStream, file);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            IoUtil.close(inputStream);
        }
    }

    private static void inflater(InputStream inputStream, OutputStream outputStream, boolean bl) {
        InflaterOutputStream inflaterOutputStream = outputStream instanceof InflaterOutputStream ? (InflaterOutputStream)outputStream : new InflaterOutputStream(outputStream, new Inflater(bl));
        IoUtil.copy(inputStream, inflaterOutputStream);
        try {
            inflaterOutputStream.finish();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    private static void deflater(InputStream inputStream, OutputStream outputStream, int n2, boolean bl) {
        DeflaterOutputStream deflaterOutputStream = outputStream instanceof DeflaterOutputStream ? (DeflaterOutputStream)outputStream : new DeflaterOutputStream(outputStream, new Deflater(n2, bl));
        IoUtil.copy(inputStream, deflaterOutputStream);
        try {
            deflaterOutputStream.finish();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    private static File buildFile(File file, String string) {
        string = string.replace('\\', '/');
        if (!FileUtil.isWindows() && string.lastIndexOf(47, string.length() - 2) > 0) {
            List list = StrUtil.split(string, '/', false, true);
            int n2 = list.size() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                file = new File(file, (String)list.get(i2));
            }
            file.mkdirs();
            string = (String)list.get(n2);
        }
        return FileUtil.file(file, string);
    }
}

