/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class RuntimeUtil {
    public static String execForStr(String ... stringArray) {
        return RuntimeUtil.execForStr(CharsetUtil.systemCharset(), stringArray);
    }

    public static String execForStr(Charset charset, String ... stringArray) {
        return RuntimeUtil.getResult(RuntimeUtil.exec(stringArray), charset);
    }

    public static List execForLines(String ... stringArray) {
        return RuntimeUtil.execForLines(CharsetUtil.systemCharset(), stringArray);
    }

    public static List execForLines(Charset charset, String ... stringArray) {
        return RuntimeUtil.getResultLines(RuntimeUtil.exec(stringArray), charset);
    }

    public static Process exec(String ... stringArray) {
        Object object;
        if (ArrayUtil.isEmpty(stringArray)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == stringArray.length) {
            object = stringArray[0];
            if (StrUtil.isBlank((CharSequence)object)) {
                throw new NullPointerException("Command is empty !");
            }
            stringArray = StrUtil.splitToArray((CharSequence)object, ' ');
        }
        try {
            object = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return object;
    }

    public static Process exec(String[] stringArray, String ... stringArray2) {
        return RuntimeUtil.exec(stringArray, null, stringArray2);
    }

    public static Process exec(String[] stringArray, File file, String ... stringArray2) {
        if (ArrayUtil.isEmpty(stringArray2)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == stringArray2.length) {
            String string = stringArray2[0];
            if (StrUtil.isBlank(string)) {
                throw new NullPointerException("Command is empty !");
            }
            stringArray2 = StrUtil.splitToArray(string, ' ');
        }
        try {
            return Runtime.getRuntime().exec(stringArray2, stringArray, file);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static List getResultLines(Process process) {
        return RuntimeUtil.getResultLines(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getResultLines(Process process, Charset charset) {
        InputStream inputStream = null;
        try {
            inputStream = process.getInputStream();
            List list = (List)IoUtil.readLines(inputStream, charset, new ArrayList());
            return list;
        }
        finally {
            IoUtil.close(inputStream);
            RuntimeUtil.destroy(process);
        }
    }

    public static String getResult(Process process) {
        return RuntimeUtil.getResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(Process process, Charset charset) {
        InputStream inputStream = null;
        try {
            inputStream = process.getInputStream();
            String string = IoUtil.read(inputStream, charset);
            return string;
        }
        finally {
            IoUtil.close(inputStream);
            RuntimeUtil.destroy(process);
        }
    }

    public static String getErrorResult(Process process) {
        return RuntimeUtil.getErrorResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorResult(Process process, Charset charset) {
        InputStream inputStream = null;
        try {
            inputStream = process.getErrorStream();
            String string = IoUtil.read(inputStream, charset);
            return string;
        }
        finally {
            IoUtil.close(inputStream);
            RuntimeUtil.destroy(process);
        }
    }

    public static void destroy(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    public static void addShutdownHook(Runnable runnable) {
        Runtime.getRuntime().addShutdownHook(runnable instanceof Thread ? (Thread)runnable : new Thread(runnable));
    }

    public static int getProcessorCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public final long getUsableMemory() {
        return RuntimeUtil.getMaxMemory() - RuntimeUtil.getTotalMemory() + RuntimeUtil.getFreeMemory();
    }
}

