/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.annotation.Alias;
import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.Filter;
import com.ccb.core.lang.SimpleCache;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.StrUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectUtil {
    private static final SimpleCache CONSTRUCTORS_CACHE = new SimpleCache();
    private static final SimpleCache FIELDS_CACHE = new SimpleCache();
    private static final SimpleCache METHODS_CACHE = new SimpleCache();

    public static Constructor getConstructor(Class clazz, Class ... classArray) {
        Constructor[] constructorArray;
        if (null == clazz) {
            return null;
        }
        for (Constructor constructor : constructorArray = ReflectUtil.getConstructors(clazz)) {
            Class[] classArray2 = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(classArray2, classArray)) continue;
            ReflectUtil.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static Constructor[] getConstructors(Class clazz) {
        Assert.notNull(clazz);
        Constructor[] constructorArray = (Constructor[])CONSTRUCTORS_CACHE.get(clazz);
        if (null != constructorArray) {
            return constructorArray;
        }
        constructorArray = ReflectUtil.getConstructorsDirectly(clazz);
        return (Constructor[])CONSTRUCTORS_CACHE.put(clazz, constructorArray);
    }

    public static Constructor[] getConstructorsDirectly(Class clazz) {
        Assert.notNull(clazz);
        return clazz.getDeclaredConstructors();
    }

    public static boolean hasField(Class clazz, String string) {
        return null != ReflectUtil.getField(clazz, string);
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        Alias alias = field.getAnnotation(Alias.class);
        if (null != alias) {
            return alias.value();
        }
        return field.getName();
    }

    public static Field getField(Class clazz, String string) {
        Object[] objectArray = ReflectUtil.getFields(clazz);
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!string.equals(ReflectUtil.getFieldName((Field)object))) continue;
                return object;
            }
        }
        return null;
    }

    public static Map getFieldMap(Class clazz) {
        Field[] fieldArray = ReflectUtil.getFields(clazz);
        HashMap hashMap = MapUtil.newHashMap(fieldArray.length);
        for (Field field : fieldArray) {
            hashMap.put(field.getName(), field);
        }
        return hashMap;
    }

    public static Field[] getFields(Class clazz) {
        Field[] fieldArray = (Field[])FIELDS_CACHE.get(clazz);
        if (null != fieldArray) {
            return fieldArray;
        }
        fieldArray = ReflectUtil.getFieldsDirectly(clazz, true);
        return (Field[])FIELDS_CACHE.put(clazz, fieldArray);
    }

    public static Field[] getFieldsDirectly(Class clazz, boolean bl) {
        Assert.notNull(clazz);
        Object[] objectArray = null;
        Class clazz2 = clazz;
        while (clazz2 != null) {
            Object[] objectArray2 = clazz2.getDeclaredFields();
            objectArray = null == objectArray ? objectArray2 : (Field[])ArrayUtil.append(objectArray, objectArray2);
            clazz2 = bl ? clazz2.getSuperclass() : null;
        }
        return objectArray;
    }

    public static Object getFieldValue(Object object, String string) {
        if (null == object || StrUtil.isBlank(string)) {
            return null;
        }
        return ReflectUtil.getFieldValue(object, ReflectUtil.getField(object instanceof Class ? (Class<?>)object : object.getClass(), string));
    }

    public static Object getStaticFieldValue(Field field) {
        return ReflectUtil.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object object, Field field) {
        Object object2;
        if (null == field) {
            return null;
        }
        if (object instanceof Class) {
            object = null;
        }
        ReflectUtil.setAccessible(field);
        try {
            object2 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UtilException(illegalAccessException, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return object2;
    }

    public static Object[] getFieldsValue(Object object) {
        Field[] fieldArray;
        if (null != object && null != (fieldArray = ReflectUtil.getFields(object instanceof Class ? (Class<?>)object : object.getClass()))) {
            Object[] objectArray = new Object[fieldArray.length];
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                objectArray[i2] = ReflectUtil.getFieldValue(object, fieldArray[i2]);
            }
            return objectArray;
        }
        return null;
    }

    public static void setFieldValue(Object object, String string, Object object2) {
        Assert.notNull(object);
        Assert.notBlank(string);
        Field field = ReflectUtil.getField(object instanceof Class ? (Class<?>)object : object.getClass(), string);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", string, object.getClass().getName());
        ReflectUtil.setFieldValue(object, field, object2);
    }

    public static void setFieldValue(Object object, Field field, Object object2) {
        Assert.notNull(field, "Field in [{}] not exist !", object);
        Class<?> clazz = field.getType();
        if (null != object2) {
            Object object3;
            if (!clazz.isAssignableFrom(object2.getClass()) && null != (object3 = Convert.convert(clazz, object2))) {
                object2 = object3;
            }
        } else {
            object2 = ClassUtil.getDefaultValue(clazz);
        }
        ReflectUtil.setAccessible(field);
        try {
            field.set(object instanceof Class ? null : object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UtilException(illegalAccessException, "IllegalAccess for {}.{}", object, field.getName());
        }
    }

    public static Set getPublicMethodNames(Class clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        Object[] objectArray = ReflectUtil.getPublicMethods(clazz);
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                hashSet.add(((Method)object).getName());
            }
        }
        return hashSet;
    }

    public static Method[] getPublicMethods(Class clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static List getPublicMethods(Class clazz, Filter filter) {
        ArrayList<Object> arrayList;
        if (null == clazz) {
            return null;
        }
        Object[] objectArray = ReflectUtil.getPublicMethods(clazz);
        if (null != filter) {
            arrayList = new ArrayList<Object>();
            for (Object object : objectArray) {
                if (!filter.accept(object)) continue;
                arrayList.add(object);
            }
        } else {
            arrayList = CollUtil.newArrayList(objectArray);
        }
        return arrayList;
    }

    public static List getPublicMethods(Class clazz, Method ... methodArray) {
        HashSet hashSet = CollUtil.newHashSet(methodArray);
        return ReflectUtil.getPublicMethods(clazz, (Object method) -> false == hashSet.contains(method));
    }

    public static List getPublicMethods(Class clazz, String ... stringArray) {
        HashSet hashSet = CollUtil.newHashSet(stringArray);
        return ReflectUtil.getPublicMethods(clazz, (Object method) -> false == hashSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class clazz, String string, Class ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object object, String string, Object ... objectArray) {
        if (null == object || StrUtil.isBlank(string)) {
            return null;
        }
        return ReflectUtil.getMethod(object.getClass(), string, ClassUtil.getClasses(objectArray));
    }

    public static Method getMethodIgnoreCase(Class clazz, String string, Class ... classArray) {
        return ReflectUtil.getMethod(clazz, true, string, classArray);
    }

    public static Method getMethod(Class clazz, String string, Class ... classArray) {
        return ReflectUtil.getMethod(clazz, false, string, classArray);
    }

    public static Method getMethod(Class clazz, boolean bl, String string, Class ... classArray) {
        if (null == clazz || StrUtil.isBlank(string)) {
            return null;
        }
        Object[] objectArray = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!StrUtil.equals(string, ((Method)object).getName(), bl) || !ClassUtil.isAllAssignableFrom(((Method)object).getParameterTypes(), classArray)) continue;
                return object;
            }
        }
        return null;
    }

    public static Method getMethodByName(Class clazz, String string) {
        return ReflectUtil.getMethodByName(clazz, false, string);
    }

    public static Method getMethodByNameIgnoreCase(Class clazz, String string) {
        return ReflectUtil.getMethodByName(clazz, true, string);
    }

    public static Method getMethodByName(Class clazz, boolean bl, String string) {
        if (null == clazz || StrUtil.isBlank(string)) {
            return null;
        }
        Object[] objectArray = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!StrUtil.equals(string, ((Method)object).getName(), bl)) continue;
                return object;
            }
        }
        return null;
    }

    public static Set getMethodNames(Class clazz) {
        Method[] methodArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (Method method : methodArray = ReflectUtil.getMethods(clazz)) {
            hashSet.add(method.getName());
        }
        return hashSet;
    }

    public static Method[] getMethods(Class clazz, Filter filter) {
        if (null == clazz) {
            return null;
        }
        return (Method[])ArrayUtil.filter((Object[])ReflectUtil.getMethods(clazz), filter);
    }

    public static Method[] getMethods(Class clazz) {
        Method[] methodArray = (Method[])METHODS_CACHE.get(clazz);
        if (null != methodArray) {
            return methodArray;
        }
        methodArray = ReflectUtil.getMethodsDirectly(clazz, true);
        return (Method[])METHODS_CACHE.put(clazz, methodArray);
    }

    public static Method[] getMethodsDirectly(Class clazz, boolean bl) {
        Assert.notNull(clazz);
        Object[] objectArray = null;
        Class clazz2 = clazz;
        while (clazz2 != null) {
            Object[] objectArray2 = clazz2.getDeclaredMethods();
            objectArray = null == objectArray ? objectArray2 : (Method[])ArrayUtil.append(objectArray, objectArray2);
            clazz2 = bl ? clazz2.getSuperclass() : null;
        }
        return objectArray;
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !"equals".equals(method.getName())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        return 1 == classArray.length && classArray[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public static Object newInstance(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new UtilException(exception, "Instance class [{}] error!", string);
        }
    }

    public static Object newInstance(Class clazz, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            Constructor constructor = ReflectUtil.getConstructor(clazz, new Class[0]);
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new UtilException(exception, "Instance class [{}] error!", clazz);
            }
        }
        Class[] classArray = ClassUtil.getClasses(objectArray);
        Constructor constructor = ReflectUtil.getConstructor(clazz, classArray);
        if (null == constructor) {
            throw new UtilException("No Constructor matched for parameter types: [{}]", new Object[]{classArray});
        }
        try {
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new UtilException(exception, "Instance class [{}] error!", clazz);
        }
    }

    public static Object newInstanceIfPossible(Class clazz) {
        Assert.notNull(clazz);
        if (clazz.isAssignableFrom(AbstractMap.class)) {
            clazz = HashMap.class;
        } else if (clazz.isAssignableFrom(List.class)) {
            clazz = ArrayList.class;
        } else if (clazz.isAssignableFrom(Set.class)) {
            clazz = HashSet.class;
        }
        try {
            return ReflectUtil.newInstance(clazz, new Object[0]);
        }
        catch (Exception exception) {
            Constructor[] constructorArray;
            for (Constructor constructor : constructorArray = ReflectUtil.getConstructors(clazz)) {
                Class[] classArray = constructor.getParameterTypes();
                if (0 == classArray.length) continue;
                ReflectUtil.setAccessible(constructor);
                try {
                    return constructor.newInstance(ClassUtil.getDefaultValues(classArray));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static Object invokeStatic(Method method, Object ... objectArray) {
        return ReflectUtil.invoke(null, method, objectArray);
    }

    public static Object invokeWithCheck(Object object, Method method, Object ... objectArray) {
        Class<?>[] classArray = method.getParameterTypes();
        if (null != objectArray) {
            Assert.isTrue(objectArray.length == classArray.length, "Params length [{}] is not fit for param length [{}] of method !", objectArray.length, classArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Class<?> clazz = classArray[i2];
                if (!clazz.isPrimitive() || null != objectArray[i2]) continue;
                objectArray[i2] = ClassUtil.getDefaultValue(clazz);
            }
        }
        return ReflectUtil.invoke(object, method, objectArray);
    }

    public static Object invoke(Object object, Method method, Object ... objectArray) {
        ReflectUtil.setAccessible(method);
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray2 = new Object[classArray.length];
        if (null != objectArray) {
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                if (i2 >= objectArray.length || null == objectArray[i2]) {
                    objectArray2[i2] = ClassUtil.getDefaultValue(classArray[i2]);
                    continue;
                }
                if (!classArray[i2].isAssignableFrom(objectArray[i2].getClass())) {
                    Object object2 = Convert.convert(classArray[i2], objectArray[i2]);
                    if (null == object2) continue;
                    objectArray2[i2] = object2;
                    continue;
                }
                objectArray2[i2] = objectArray[i2];
            }
        }
        try {
            return method.invoke(ClassUtil.isStatic(method) ? null : object, objectArray2);
        }
        catch (Exception exception) {
            throw new UtilException(exception);
        }
    }

    public static Object invoke(Object object, String string, Object ... objectArray) {
        Method method = ReflectUtil.getMethodOfObj(object, string, objectArray);
        if (null == method) {
            throw new UtilException(StrUtil.format((CharSequence)"No such method: [{}]", string));
        }
        return ReflectUtil.invoke(object, method, objectArray);
    }

    public static AccessibleObject setAccessible(AccessibleObject accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }
}

