/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.date.DateField;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.DateUtil;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.UUID;
import com.ccb.core.lang.WeightRandom;
import com.ccb.core.lang.WeightRandom$WeightObj;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.StrUtil;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] byArray) {
        return null == byArray ? new SecureRandom() : new SecureRandom(byArray);
    }

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UtilException(noSuchAlgorithmException);
        }
    }

    public static Random getRandom(boolean bl) {
        return bl ? RandomUtil.getSecureRandom() : RandomUtil.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtil.randomInt(2);
    }

    public static int randomInt(int n2, int n3) {
        return RandomUtil.getRandom().nextInt(n2, n3);
    }

    public static int randomInt() {
        return RandomUtil.getRandom().nextInt();
    }

    public static int randomInt(int n2) {
        return RandomUtil.getRandom().nextInt(n2);
    }

    public static long randomLong(long l2, long l3) {
        return RandomUtil.getRandom().nextLong(l2, l3);
    }

    public static long randomLong() {
        return RandomUtil.getRandom().nextLong();
    }

    public static long randomLong(long l2) {
        return RandomUtil.getRandom().nextLong(l2);
    }

    public static double randomDouble(double d2, double d3) {
        return RandomUtil.getRandom().nextDouble(d2, d3);
    }

    public static double randomDouble(double d2, double d3, int n2, RoundingMode roundingMode) {
        return NumberUtil.round(RandomUtil.randomDouble(d2, d3), n2, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomUtil.getRandom().nextDouble();
    }

    public static double randomDouble(int n2, RoundingMode roundingMode) {
        return NumberUtil.round(RandomUtil.randomDouble(), n2, roundingMode).doubleValue();
    }

    public static double randomDouble(double d2) {
        return RandomUtil.getRandom().nextDouble(d2);
    }

    public static double randomDouble(double d2, int n2, RoundingMode roundingMode) {
        return NumberUtil.round(RandomUtil.randomDouble(d2), n2, roundingMode).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal bigDecimal) {
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble(bigDecimal.doubleValue()));
    }

    public static BigDecimal randomBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble(bigDecimal.doubleValue(), bigDecimal2.doubleValue()));
    }

    public static byte[] randomBytes(int n2) {
        byte[] byArray = new byte[n2];
        RandomUtil.getRandom().nextBytes(byArray);
        return byArray;
    }

    public static Object randomEle(List list) {
        return RandomUtil.randomEle(list, list.size());
    }

    public static Object randomEle(List list, int n2) {
        return list.get(RandomUtil.randomInt(n2));
    }

    public static Object randomEle(Object[] objectArray) {
        return RandomUtil.randomEle(objectArray, objectArray.length);
    }

    public static Object randomEle(Object[] objectArray, int n2) {
        return objectArray[RandomUtil.randomInt(n2)];
    }

    public static List randomEles(List list, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        int n3 = list.size();
        while (arrayList.size() < n2) {
            arrayList.add(RandomUtil.randomEle(list, n3));
        }
        return arrayList;
    }

    public static List randomEleList(List list, int n2) {
        if (n2 >= list.size()) {
            return list;
        }
        int[] nArray = ArrayUtil.sub(RandomUtil.randomInts(list.size()), 0, n2);
        ArrayList arrayList = new ArrayList();
        for (int n3 : nArray) {
            arrayList.add(list.get(n3));
        }
        return arrayList;
    }

    public static Set randomEleSet(Collection collection, int n2) {
        ArrayList arrayList = CollUtil.distinct(collection);
        if (n2 > arrayList.size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(n2);
        int n3 = arrayList.size();
        while (linkedHashSet.size() < n2) {
            linkedHashSet.add(RandomUtil.randomEle(arrayList, n3));
        }
        return linkedHashSet;
    }

    public static int[] randomInts(int n2) {
        int[] nArray = ArrayUtil.range(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = RandomUtil.randomInt(i2, n2);
            ArrayUtil.swap(nArray, i2, n3);
        }
        return nArray;
    }

    public static String randomString(int n2) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, n2);
    }

    public static String randomStringUpper(int n2) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, n2).toUpperCase();
    }

    public static String randomStringWithoutStr(int n2, String string) {
        String string2 = BASE_CHAR_NUMBER;
        string2 = StrUtil.removeAll((CharSequence)string2, string.toCharArray());
        return RandomUtil.randomString(string2, n2);
    }

    public static String randomNumbers(int n2) {
        return RandomUtil.randomString(BASE_NUMBER, n2);
    }

    public static String randomString(String string, int n2) {
        if (StrUtil.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = RandomUtil.randomInt(n3);
            stringBuilder.append(string.charAt(n4));
        }
        return stringBuilder.toString();
    }

    public static char randomNumber() {
        return RandomUtil.randomChar(BASE_NUMBER);
    }

    public static char randomChar() {
        return RandomUtil.randomChar(BASE_CHAR_NUMBER);
    }

    public static char randomChar(String string) {
        return string.charAt(RandomUtil.randomInt(string.length()));
    }

    public static Color randomColor() {
        ThreadLocalRandom threadLocalRandom = RandomUtil.getRandom();
        return new Color(((Random)threadLocalRandom).nextInt(256), ((Random)threadLocalRandom).nextInt(256), ((Random)threadLocalRandom).nextInt(256));
    }

    public static WeightRandom weightRandom(WeightRandom$WeightObj[] weightRandom$WeightObjArray) {
        return new WeightRandom(weightRandom$WeightObjArray);
    }

    public static WeightRandom weightRandom(Iterable iterable) {
        return new WeightRandom(iterable);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String simpleUUID() {
        return UUID.randomUUID().toString(true);
    }

    public static DateTime randomDay(int n2, int n3) {
        return RandomUtil.randomDate(DateUtil.date(), DateField.DAY_OF_YEAR, n2, n3);
    }

    public static DateTime randomDate(Date date, DateField dateField, int n2, int n3) {
        if (null == date) {
            date = DateUtil.date();
        }
        return DateUtil.offset(date, dateField, RandomUtil.randomInt(n2, n3));
    }
}

