/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.collection.IterUtil;
import com.ccb.core.comparator.CompareUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.FastByteArrayOutputStream;
import com.ccb.core.io.IoUtil;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ObjectUtil {
    public static boolean equals(Object object, Object object2) {
        return ObjectUtil.equal(object, object2);
    }

    public static boolean equal(Object object, Object object2) {
        if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
            return NumberUtil.equals((BigDecimal)object, (BigDecimal)object2);
        }
        return Objects.equals(object, object2);
    }

    public static boolean notEqual(Object object, Object object2) {
        return false == ObjectUtil.equal(object, object2);
    }

    public static int length(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length();
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            int n2 = 0;
            while (iterator.hasNext()) {
                ++n2;
                iterator.next();
            }
            return n2;
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                ++n3;
                enumeration.nextElement();
            }
            return n3;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        return -1;
    }

    public static boolean contains(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            if (object2 == null) {
                return false;
            }
            return ((String)object).contains(object2.toString());
        }
        if (object instanceof Collection) {
            return ((Collection)object).contains(object2);
        }
        if (object instanceof Map) {
            return ((Map)object).containsValue(object2);
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!ObjectUtil.equal(e2, object2)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                Object e3 = enumeration.nextElement();
                if (!ObjectUtil.equal(e3, object2)) continue;
                return true;
            }
            return false;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = Array.get(object, i2);
                if (!ObjectUtil.equal(object3, object2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object object) {
        return null == object || object.equals(null);
    }

    public static boolean isNotNull(Object object) {
        return null != object && false == object.equals(null);
    }

    public static boolean isEmpty(Object object) {
        if (null == object) {
            return true;
        }
        if (object instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)object);
        }
        if (object instanceof Map) {
            return MapUtil.isEmpty((Map)object);
        }
        if (object instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)object);
        }
        if (object instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)object);
        }
        if (ArrayUtil.isArray(object)) {
            return ArrayUtil.isEmpty(object);
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return false == ObjectUtil.isEmpty(object);
    }

    public static Object defaultIfNull(Object object, Object object2) {
        return null != object ? object : object2;
    }

    public static CharSequence defaultIfEmpty(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.isEmpty(charSequence) ? charSequence2 : charSequence;
    }

    public static CharSequence defaultIfBlank(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.isBlank(charSequence) ? charSequence2 : charSequence;
    }

    public static Object clone(Object object) {
        Object object2 = ArrayUtil.clone(object);
        if (null == object2) {
            object2 = object instanceof Cloneable ? ReflectUtil.invoke(object, "clone", new Object[0]) : ObjectUtil.cloneByStream(object);
        }
        return object2;
    }

    public static Object cloneIfPossible(Object object) {
        Object object2 = null;
        try {
            object2 = ObjectUtil.clone(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2 == null ? object : object2;
    }

    public static Object cloneByStream(Object object) {
        Object object2;
        if (!(object instanceof Serializable)) {
            return null;
        }
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(fastByteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(fastByteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (Exception exception) {
            try {
                throw new UtilException(exception);
            }
            catch (Throwable throwable) {
                IoUtil.close(objectOutputStream);
                throw throwable;
            }
        }
        IoUtil.close(objectOutputStream);
        return object2;
    }

    public static byte[] serialize(Object object) {
        if (!(object instanceof Serializable)) {
            return null;
        }
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        IoUtil.writeObjects(fastByteArrayOutputStream, false, (Serializable)object);
        return fastByteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] byArray) {
        return IoUtil.readObj(new ByteArrayInputStream(byArray));
    }

    public static Object unserialize(byte[] byArray) {
        return ObjectUtil.deserialize(byArray);
    }

    public static boolean isBasicType(Object object) {
        return ClassUtil.isBasicType(object.getClass());
    }

    public static boolean isValidIfNumber(Object object) {
        if (object instanceof Number) {
            return NumberUtil.isValidNumber((Number)object);
        }
        return true;
    }

    public static int compare(Comparable comparable, Comparable comparable2) {
        return CompareUtil.compare(comparable, comparable2);
    }

    public static int compare(Comparable comparable, Comparable comparable2, boolean bl) {
        return CompareUtil.compare(comparable, comparable2, bl);
    }

    public static Class getTypeArgument(Object object) {
        return ObjectUtil.getTypeArgument(object, 0);
    }

    public static Class getTypeArgument(Object object, int n2) {
        return ClassUtil.getTypeArgument(object.getClass(), n2);
    }

    public static String toString(Object object) {
        if (null == object) {
            return "null";
        }
        if (object instanceof Map) {
            return object.toString();
        }
        return Convert.toStr(object);
    }

    public static int emptyCount(Object ... objectArray) {
        return ArrayUtil.emptyCount(objectArray);
    }

    public static boolean hasEmpty(Object ... objectArray) {
        return ArrayUtil.hasEmpty(objectArray);
    }

    public static boolean isAllEmpty(Object ... objectArray) {
        return ArrayUtil.isAllEmpty(objectArray);
    }

    public static boolean isAllNotEmpty(Object ... objectArray) {
        return ArrayUtil.isAllNotEmpty(objectArray);
    }
}

