/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.awt.Color;
import java.math.BigInteger;
import java.nio.charset.Charset;

public class HexUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean isHexNumber(String string) {
        int n2;
        int n3 = n2 = string.startsWith("-") ? 1 : 0;
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2) || string.startsWith("#", n2)) {
            try {
                Long.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static char[] encodeHex(byte[] byArray) {
        return HexUtil.encodeHex(byArray, true);
    }

    public static char[] encodeHex(String string, Charset charset) {
        return HexUtil.encodeHex(StrUtil.bytes((CharSequence)string, charset), true);
    }

    public static char[] encodeHex(byte[] byArray, boolean bl) {
        return HexUtil.encodeHex(byArray, bl ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexStr(byte[] byArray) {
        return HexUtil.encodeHexStr(byArray, true);
    }

    public static String encodeHexStr(String string, Charset charset) {
        return HexUtil.encodeHexStr(StrUtil.bytes((CharSequence)string, charset), true);
    }

    public static String encodeHexStr(String string) {
        return HexUtil.encodeHexStr(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeHexStr(byte[] byArray, boolean bl) {
        return HexUtil.encodeHexStr(byArray, bl ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String decodeHexStr(String string) {
        return HexUtil.decodeHexStr(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String decodeHexStr(String string, Charset charset) {
        if (StrUtil.isEmpty(string)) {
            return string;
        }
        return HexUtil.decodeHexStr(string.toCharArray(), charset);
    }

    public static String decodeHexStr(char[] cArray, Charset charset) {
        return StrUtil.str(HexUtil.decodeHex(cArray), charset);
    }

    public static byte[] decodeHex(char[] cArray) {
        int n2 = cArray.length;
        if ((n2 & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] byArray = new byte[n2 >> 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = HexUtil.toDigit(cArray[n4], n4) << 4;
            n5 |= HexUtil.toDigit(cArray[++n4], n4);
            ++n4;
            byArray[n3] = (byte)(n5 & 0xFF);
            ++n3;
        }
        return byArray;
    }

    public static byte[] decodeHex(String string) {
        if (StrUtil.isEmpty(string)) {
            return null;
        }
        string = StrUtil.removeAll((CharSequence)string, ' ');
        return HexUtil.decodeHex(string.toCharArray());
    }

    public static String encodeColor(Color color) {
        return HexUtil.encodeColor(color, "#");
    }

    public static String encodeColor(Color color, String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = Integer.toHexString(color.getRed());
        if (1 == string2.length()) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        string2 = Integer.toHexString(color.getGreen());
        if (1 == string2.length()) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        string2 = Integer.toHexString(color.getBlue());
        if (1 == string2.length()) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static Color decodeColor(String string) {
        return Color.decode(string);
    }

    public static String toUnicodeHex(int n2) {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append("\\u");
        String string = HexUtil.toHex(n2);
        int n3 = string.length();
        if (n3 < 4) {
            stringBuilder.append("0000", 0, 4 - n3);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String toUnicodeHex(char c2) {
        return "\\u" + DIGITS_LOWER[c2 >> 12 & 0xF] + DIGITS_LOWER[c2 >> 8 & 0xF] + DIGITS_LOWER[c2 >> 4 & 0xF] + DIGITS_LOWER[c2 & 0xF];
    }

    public static String toHex(int n2) {
        return Integer.toHexString(n2);
    }

    public static String toHex(long l2) {
        return Long.toHexString(l2);
    }

    public static void appendHex(StringBuilder stringBuilder, byte by, boolean bl) {
        char[] cArray = bl ? DIGITS_LOWER : DIGITS_UPPER;
        int n2 = (by & 0xF0) >>> 4;
        int n3 = by & 0xF;
        stringBuilder.append(cArray[n2]);
        stringBuilder.append(cArray[n3]);
    }

    public static BigInteger toBigInteger(String string) {
        if (null == string) {
            return null;
        }
        return new BigInteger(string, 16);
    }

    private static String encodeHexStr(byte[] byArray, char[] cArray) {
        return new String(HexUtil.encodeHex(byArray, cArray));
    }

    private static char[] encodeHex(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(0xF0 & byArray[i2]) >>> 4];
            cArray2[n3++] = cArray[0xF & byArray[i2]];
        }
        return cArray2;
    }

    private static int toDigit(char c2, int n2) {
        int n3 = Character.digit(c2, 16);
        if (n3 == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + c2 + " at index " + n2);
        }
        return n3;
    }
}

