/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.lang.Filter;
import com.ccb.core.text.escape.Html4Escape;
import com.ccb.core.text.escape.Html4Unescape;
import com.ccb.core.util.StrUtil;

public class EscapeUtil {
    private static final String NOT_ESCAPE_CHARS = "*@-_+./";
    private static final Filter JS_ESCAPE_FILTER = c2 -> false == (Character.isDigit(c2.charValue()) || Character.isLowerCase(c2.charValue()) || Character.isUpperCase(c2.charValue()) || StrUtil.contains((CharSequence)NOT_ESCAPE_CHARS, c2.charValue()));

    public static String escapeHtml4(CharSequence charSequence) {
        Html4Escape html4Escape = new Html4Escape();
        return html4Escape.replace(charSequence).toString();
    }

    public static String unescapeHtml4(CharSequence charSequence) {
        Html4Unescape html4Unescape = new Html4Unescape();
        return html4Unescape.replace(charSequence).toString();
    }

    public static String escape(CharSequence charSequence) {
        return EscapeUtil.escape(charSequence, JS_ESCAPE_FILTER);
    }

    public static String escapeAll(CharSequence charSequence) {
        return EscapeUtil.escape(charSequence, c2 -> true);
    }

    public static String escape(CharSequence charSequence, Filter filter) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() * 6);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (!filter.accept(Character.valueOf(c2))) {
                stringBuilder.append(c2);
                continue;
            }
            if (c2 < '\u0100') {
                stringBuilder.append("%");
                if (c2 < '\u0010') {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toString(c2, 16));
                continue;
            }
            stringBuilder.append("%u");
            stringBuilder.append(Integer.toString(c2, 16));
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        if (StrUtil.isBlank(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf("%", n2);
            if (n3 == n2) {
                char c2;
                if (string.charAt(n3 + 1) == 'u') {
                    c2 = (char)Integer.parseInt(string.substring(n3 + 2, n3 + 6), 16);
                    stringBuilder.append(c2);
                    n2 = n3 + 6;
                    continue;
                }
                c2 = (char)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16);
                stringBuilder.append(c2);
                n2 = n3 + 3;
                continue;
            }
            if (n3 == -1) {
                stringBuilder.append(string.substring(n2));
                n2 = string.length();
                continue;
            }
            stringBuilder.append(string, n2, n3);
            n2 = n3;
        }
        return stringBuilder.toString();
    }

    public static String safeUnescape(String string) {
        try {
            return EscapeUtil.unescape(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

