/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.collection.CollectionUtil;
import com.ccb.core.collection.IterUtil;
import com.ccb.core.comparator.CompareUtil;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.Editor;
import com.ccb.core.lang.Filter;
import com.ccb.core.lang.Matcher;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class ArrayUtil {
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static Object[] defaultIfEmpty(Object[] objectArray, Object[] objectArray2) {
        return ArrayUtil.isEmpty(objectArray) ? objectArray2 : objectArray;
    }

    public static boolean isEmpty(Object object) {
        if (object != null) {
            if (ArrayUtil.isArray(object)) {
                return 0 == Array.getLength(object);
            }
            return false;
        }
        return true;
    }

    public static boolean isEmpty(long[] lArray) {
        return lArray == null || lArray.length == 0;
    }

    public static boolean isEmpty(int[] nArray) {
        return nArray == null || nArray.length == 0;
    }

    public static boolean isEmpty(short[] sArray) {
        return sArray == null || sArray.length == 0;
    }

    public static boolean isEmpty(char[] cArray) {
        return cArray == null || cArray.length == 0;
    }

    public static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    public static boolean isEmpty(double[] dArray) {
        return dArray == null || dArray.length == 0;
    }

    public static boolean isEmpty(float[] fArray) {
        return fArray == null || fArray.length == 0;
    }

    public static boolean isEmpty(boolean[] blArray) {
        return blArray == null || blArray.length == 0;
    }

    public static boolean isNotEmpty(Object[] objectArray) {
        return objectArray != null && objectArray.length != 0;
    }

    public static boolean isNotEmpty(Object object) {
        return false == ArrayUtil.isEmpty(object);
    }

    public static boolean isNotEmpty(long[] lArray) {
        return false == ArrayUtil.isEmpty(lArray);
    }

    public static boolean isNotEmpty(int[] nArray) {
        return false == ArrayUtil.isEmpty(nArray);
    }

    public static boolean isNotEmpty(short[] sArray) {
        return false == ArrayUtil.isEmpty(sArray);
    }

    public static boolean isNotEmpty(char[] cArray) {
        return false == ArrayUtil.isEmpty(cArray);
    }

    public static boolean isNotEmpty(byte[] byArray) {
        return false == ArrayUtil.isEmpty(byArray);
    }

    public static boolean isNotEmpty(double[] dArray) {
        return false == ArrayUtil.isEmpty(dArray);
    }

    public static boolean isNotEmpty(float[] fArray) {
        return false == ArrayUtil.isEmpty(fArray);
    }

    public static boolean isNotEmpty(boolean[] blArray) {
        return false == ArrayUtil.isEmpty(blArray);
    }

    public static boolean hasNull(Object ... objectArray) {
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (null != object) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllNull(Object ... objectArray) {
        return null == ArrayUtil.firstNonNull(objectArray);
    }

    public static Object firstNonNull(Object ... objectArray) {
        return ArrayUtil.firstMatch(Objects::nonNull, objectArray);
    }

    public static Object firstMatch(Matcher matcher, Object ... objectArray) {
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!matcher.match(object)) continue;
                return object;
            }
        }
        return null;
    }

    public static Object[] newArray(Class clazz, int n2) {
        return (Object[])Array.newInstance(clazz, n2);
    }

    public static Object[] newArray(int n2) {
        return new Object[n2];
    }

    public static Class getComponentType(Object object) {
        return null == object ? null : object.getClass().getComponentType();
    }

    public static Class getComponentType(Class clazz) {
        return null == clazz ? null : clazz.getComponentType();
    }

    public static Class getArrayType(Class clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    public static Object[] cast(Class clazz, Object object) {
        if (null == object) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == clazz) {
            return (Object[])object;
        }
        Class<?> clazz2 = clazz.isArray() ? clazz.getComponentType() : clazz;
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = ArrayUtil.newArray(clazz2, objectArray.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static Object[] append(Object[] objectArray, Object ... objectArray2) {
        if (ArrayUtil.isEmpty(objectArray)) {
            return objectArray2;
        }
        return ArrayUtil.insert(objectArray, objectArray.length, objectArray2);
    }

    public static Object append(Object object, Object ... objectArray) {
        if (ArrayUtil.isEmpty(object)) {
            return objectArray;
        }
        return ArrayUtil.insert(object, ArrayUtil.length(object), objectArray);
    }

    public static Object[] setOrAppend(Object[] objectArray, int n2, Object object) {
        if (n2 < objectArray.length) {
            Array.set(objectArray, n2, object);
            return objectArray;
        }
        return ArrayUtil.append(objectArray, object);
    }

    public static Object setOrAppend(Object object, int n2, Object object2) {
        if (n2 < ArrayUtil.length(object)) {
            Array.set(object, n2, object2);
            return object;
        }
        return ArrayUtil.append(object, object2);
    }

    public static Object[] insert(Object[] objectArray, int n2, Object ... objectArray2) {
        return (Object[])ArrayUtil.insert((Object)objectArray, n2, objectArray2);
    }

    public static Object insert(Object object, int n2, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            return object;
        }
        if (ArrayUtil.isEmpty(object)) {
            return objectArray;
        }
        int n3 = ArrayUtil.length(object);
        if (n2 < 0) {
            n2 = n2 % n3 + n3;
        }
        Object[] objectArray2 = ArrayUtil.newArray(object.getClass().getComponentType(), Math.max(n3, n2) + objectArray.length);
        System.arraycopy(object, 0, objectArray2, 0, Math.min(n3, n2));
        System.arraycopy(objectArray, 0, objectArray2, n2, objectArray.length);
        if (n2 < n3) {
            System.arraycopy(object, n2, objectArray2, n2 + objectArray.length, n3 - n2);
        }
        return objectArray2;
    }

    public static Object[] resize(Object[] objectArray, int n2, Class clazz) {
        if (n2 < 0) {
            return objectArray;
        }
        Object[] objectArray2 = ArrayUtil.newArray(clazz, n2);
        if (n2 > 0 && ArrayUtil.isNotEmpty(objectArray)) {
            System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, n2));
        }
        return objectArray2;
    }

    public static Object resize(Object object, int n2) {
        if (n2 < 0) {
            return object;
        }
        if (null == object) {
            return null;
        }
        int n3 = ArrayUtil.length(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        if (n2 > 0 && ArrayUtil.isNotEmpty(object)) {
            System.arraycopy(object, 0, object2, 0, Math.min(n3, n2));
        }
        return object2;
    }

    public static byte[] resize(byte[] byArray, int n2) {
        if (n2 < 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (n2 > 0 && ArrayUtil.isNotEmpty(byArray)) {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n2));
        }
        return byArray2;
    }

    public static Object[] resize(Object[] objectArray, int n2) {
        return ArrayUtil.resize(objectArray, n2, objectArray.getClass().getComponentType());
    }

    public static Object[] addAll(Object[] ... objectArray) {
        if (objectArray.length == 1) {
            return objectArray[0];
        }
        int n2 = 0;
        for (Object[] objectArray2 : objectArray) {
            if (null == objectArray2) continue;
            n2 += objectArray2.length;
        }
        Object[][] objectArray3 = ArrayUtil.newArray(objectArray.getClass().getComponentType().getComponentType(), n2);
        n2 = 0;
        for (Object[] objectArray4 : objectArray) {
            if (null == objectArray4) continue;
            System.arraycopy(objectArray4, 0, objectArray3, n2, objectArray4.length);
            n2 += objectArray4.length;
        }
        return objectArray3;
    }

    public static byte[] addAll(byte[] ... byArray) {
        if (byArray.length == 1) {
            return byArray[0];
        }
        int n2 = 0;
        for (byte[] byArray2 : byArray) {
            if (null == byArray2) continue;
            n2 += byArray2.length;
        }
        byte[] byArray3 = new byte[n2];
        n2 = 0;
        for (byte[] byArray4 : byArray) {
            if (null == byArray4) continue;
            System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
            n2 += byArray4.length;
        }
        return byArray3;
    }

    public static int[] addAll(int[] ... nArray) {
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n2 = 0;
        for (int[] nArray2 : nArray) {
            if (null == nArray2) continue;
            n2 += nArray2.length;
        }
        int[] nArray3 = new int[n2];
        n2 = 0;
        for (int[] nArray4 : nArray) {
            if (null == nArray4) continue;
            System.arraycopy(nArray4, 0, nArray3, n2, nArray4.length);
            n2 += nArray4.length;
        }
        return nArray3;
    }

    public static long[] addAll(long[] ... lArray) {
        if (lArray.length == 1) {
            return lArray[0];
        }
        int n2 = 0;
        for (long[] lArray2 : lArray) {
            if (null == lArray2) continue;
            n2 += lArray2.length;
        }
        long[] lArray3 = new long[n2];
        n2 = 0;
        for (long[] lArray4 : lArray) {
            if (null == lArray4) continue;
            System.arraycopy(lArray4, 0, lArray3, n2, lArray4.length);
            n2 += lArray4.length;
        }
        return lArray3;
    }

    public static double[] addAll(double[] ... dArray) {
        if (dArray.length == 1) {
            return dArray[0];
        }
        int n2 = 0;
        for (double[] dArray2 : dArray) {
            if (null == dArray2) continue;
            n2 += dArray2.length;
        }
        double[] dArray3 = new double[n2];
        n2 = 0;
        for (double[] dArray4 : dArray) {
            if (null == dArray4) continue;
            System.arraycopy(dArray4, 0, dArray3, n2, dArray4.length);
            n2 += dArray4.length;
        }
        return dArray3;
    }

    public static float[] addAll(float[] ... fArray) {
        if (fArray.length == 1) {
            return fArray[0];
        }
        int n2 = 0;
        for (float[] fArray2 : fArray) {
            if (null == fArray2) continue;
            n2 += fArray2.length;
        }
        float[] fArray3 = new float[n2];
        n2 = 0;
        for (float[] fArray4 : fArray) {
            if (null == fArray4) continue;
            System.arraycopy(fArray4, 0, fArray3, n2, fArray4.length);
            n2 += fArray4.length;
        }
        return fArray3;
    }

    public static char[] addAll(char[] ... cArray) {
        if (cArray.length == 1) {
            return cArray[0];
        }
        int n2 = 0;
        for (char[] cArray2 : cArray) {
            if (null == cArray2) continue;
            n2 += cArray2.length;
        }
        char[] cArray3 = new char[n2];
        n2 = 0;
        for (char[] cArray4 : cArray) {
            if (null == cArray4) continue;
            System.arraycopy(cArray4, 0, cArray3, n2, cArray4.length);
            n2 += cArray4.length;
        }
        return cArray3;
    }

    public static boolean[] addAll(boolean[] ... blArray) {
        if (blArray.length == 1) {
            return blArray[0];
        }
        int n2 = 0;
        for (boolean[] blArray2 : blArray) {
            if (null == blArray2) continue;
            n2 += blArray2.length;
        }
        boolean[] blArray3 = new boolean[n2];
        n2 = 0;
        for (boolean[] blArray4 : blArray) {
            if (null == blArray4) continue;
            System.arraycopy(blArray4, 0, blArray3, n2, blArray4.length);
            n2 += blArray4.length;
        }
        return blArray3;
    }

    public static short[] addAll(short[] ... sArray) {
        if (sArray.length == 1) {
            return sArray[0];
        }
        int n2 = 0;
        for (short[] sArray2 : sArray) {
            if (null == sArray2) continue;
            n2 += sArray2.length;
        }
        short[] sArray3 = new short[n2];
        n2 = 0;
        for (short[] sArray4 : sArray) {
            if (null == sArray4) continue;
            System.arraycopy(sArray4, 0, sArray3, n2, sArray4.length);
            n2 += sArray4.length;
        }
        return sArray3;
    }

    public static Object copy(Object object, int n2, Object object2, int n3, int n4) {
        System.arraycopy(object, n2, object2, n3, n4);
        return object2;
    }

    public static Object copy(Object object, Object object2, int n2) {
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static Object[] clone(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return (Object[])objectArray.clone();
    }

    public static Object clone(Object object) {
        if (null == object) {
            return null;
        }
        if (ArrayUtil.isArray(object)) {
            Object object2;
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz.isPrimitive()) {
                int n2 = Array.getLength(object);
                object2 = Array.newInstance(clazz, n2);
                while (n2-- > 0) {
                    Array.set(object2, n2, Array.get(object, n2));
                }
            } else {
                object2 = ((Object[])object).clone();
            }
            return object2;
        }
        return null;
    }

    public static int[] range(int n2) {
        return ArrayUtil.range(0, n2, 1);
    }

    public static int[] range(int n2, int n3) {
        return ArrayUtil.range(n2, n3, 1);
    }

    public static int[] range(int n2, int n3, int n4) {
        int n5;
        if (n2 > n3) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        n5 = n3 - n2;
        int n6 = n5 / n4;
        if (n5 % n4 != 0) {
            ++n6;
        }
        int[] nArray = new int[n6];
        for (int i2 = 0; i2 < n6; ++i2) {
            nArray[i2] = n2;
            n2 += n4;
        }
        return nArray;
    }

    public static byte[][] split(byte[] byArray, int n2) {
        int n3 = byArray.length / n2;
        int n4 = byArray.length % n2;
        int n5 = 0;
        if (n4 != 0) {
            n5 = 1;
        }
        byte[][] byArrayArray = new byte[n3 + n5][];
        for (int i2 = 0; i2 < n3 + n5; ++i2) {
            byte[] byArray2 = new byte[n2];
            if (i2 == n3 + n5 - 1 && n4 != 0) {
                System.arraycopy(byArray, i2 * n2, byArray2, 0, n4);
            } else {
                System.arraycopy(byArray, i2 * n2, byArray2, 0, n2);
            }
            byArrayArray[i2] = byArray2;
        }
        return byArrayArray;
    }

    public static Object[] filter(Object[] objectArray, Editor editor) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (Object object : objectArray) {
            Object object2 = editor.edit(object);
            if (null == object2) continue;
            arrayList.add(object2);
        }
        return arrayList.toArray(Arrays.copyOf(objectArray, arrayList.size()));
    }

    public static void edit(Object[] objectArray, Editor editor) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = editor.edit(objectArray[i2]);
        }
    }

    public static Object[] filter(Object[] objectArray, Filter filter) {
        if (null == filter) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (Object object : objectArray) {
            if (!filter.accept(object)) continue;
            arrayList.add(object);
        }
        Object[] objectArray2 = ArrayUtil.newArray(objectArray.getClass().getComponentType(), arrayList.size());
        return arrayList.toArray(objectArray2);
    }

    public static Object[] removeNull(Object[] objectArray) {
        return ArrayUtil.filter(objectArray, (Object object) -> object);
    }

    public static CharSequence[] removeEmpty(CharSequence[] charSequenceArray) {
        return (CharSequence[])ArrayUtil.filter((Object[])charSequenceArray, (Object charSequence) -> false == StrUtil.isEmpty(charSequence));
    }

    public static CharSequence[] removeBlank(CharSequence[] charSequenceArray) {
        return (CharSequence[])ArrayUtil.filter((Object[])charSequenceArray, (Object charSequence) -> false == StrUtil.isBlank(charSequence));
    }

    public static String[] nullToEmpty(String[] stringArray) {
        return (String[])ArrayUtil.filter((Object[])stringArray, (Object string) -> null == string ? "" : string);
    }

    public static Map zip(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (ArrayUtil.isEmpty(objectArray) || ArrayUtil.isEmpty(objectArray2)) {
            return null;
        }
        int n2 = Math.min(objectArray.length, objectArray2.length);
        HashMap hashMap = CollUtil.newHashMap(n2, bl);
        for (int i2 = 0; i2 < n2; ++i2) {
            hashMap.put(objectArray[i2], objectArray2[i2]);
        }
        return hashMap;
    }

    public static Map zip(Object[] objectArray, Object[] objectArray2) {
        return ArrayUtil.zip(objectArray, objectArray2, false);
    }

    public static int indexOf(Object[] objectArray, Object object) {
        if (null != objectArray) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (!ObjectUtil.equal(object, objectArray[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence[] charSequenceArray, CharSequence charSequence) {
        if (null != charSequenceArray) {
            for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
                if (!StrUtil.equalsIgnoreCase(charSequenceArray[i2], charSequence)) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] objectArray, Object object) {
        if (null != objectArray) {
            for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                if (!ObjectUtil.equal(object, objectArray[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        return ArrayUtil.indexOf(objectArray, object) > -1;
    }

    public static boolean containsAny(Object[] objectArray, Object ... objectArray2) {
        for (Object object : objectArray2) {
            if (!ArrayUtil.contains(objectArray, object)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(CharSequence[] charSequenceArray, CharSequence charSequence) {
        return ArrayUtil.indexOfIgnoreCase(charSequenceArray, charSequence) > -1;
    }

    public static int indexOf(long[] lArray, long l2) {
        if (null != lArray) {
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                if (l2 != lArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(long[] lArray, long l2) {
        if (null != lArray) {
            for (int i2 = lArray.length - 1; i2 >= 0; --i2) {
                if (l2 != lArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(long[] lArray, long l2) {
        return ArrayUtil.indexOf(lArray, l2) > -1;
    }

    public static int indexOf(int[] nArray, int n2) {
        if (null != nArray) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n2 != nArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] nArray, int n2) {
        if (null != nArray) {
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                if (n2 != nArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(int[] nArray, int n2) {
        return ArrayUtil.indexOf(nArray, n2) > -1;
    }

    public static int indexOf(short[] sArray, short s2) {
        if (null != sArray) {
            for (int i2 = 0; i2 < sArray.length; ++i2) {
                if (s2 != sArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(short[] sArray, short s2) {
        if (null != sArray) {
            for (int i2 = sArray.length - 1; i2 >= 0; --i2) {
                if (s2 != sArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(short[] sArray, short s2) {
        return ArrayUtil.indexOf(sArray, s2) > -1;
    }

    public static int indexOf(char[] cArray, char c2) {
        if (null != cArray) {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (c2 != cArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] cArray, char c2) {
        if (null != cArray) {
            for (int i2 = cArray.length - 1; i2 >= 0; --i2) {
                if (c2 != cArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(char[] cArray, char c2) {
        return ArrayUtil.indexOf(cArray, c2) > -1;
    }

    public static int indexOf(byte[] byArray, byte by) {
        if (null != byArray) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (by != byArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] byArray, byte by) {
        if (null != byArray) {
            for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
                if (by != byArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(byte[] byArray, byte by) {
        return ArrayUtil.indexOf(byArray, by) > -1;
    }

    public static int indexOf(double[] dArray, double d2) {
        if (null != dArray) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (!NumberUtil.equals(d2, dArray[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(double[] dArray, double d2) {
        if (null != dArray) {
            for (int i2 = dArray.length - 1; i2 >= 0; --i2) {
                if (!NumberUtil.equals(d2, dArray[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(double[] dArray, double d2) {
        return ArrayUtil.indexOf(dArray, d2) > -1;
    }

    public static int indexOf(float[] fArray, float f2) {
        if (null != fArray) {
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                if (!NumberUtil.equals(f2, fArray[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(float[] fArray, float f2) {
        if (null != fArray) {
            for (int i2 = fArray.length - 1; i2 >= 0; --i2) {
                if (!NumberUtil.equals(f2, fArray[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(float[] fArray, float f2) {
        return ArrayUtil.indexOf(fArray, f2) > -1;
    }

    public static int indexOf(boolean[] blArray, boolean bl) {
        if (null != blArray) {
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                if (bl != blArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl) {
        if (null != blArray) {
            for (int i2 = blArray.length - 1; i2 >= 0; --i2) {
                if (bl != blArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean contains(boolean[] blArray, boolean bl) {
        return ArrayUtil.indexOf(blArray, bl) > -1;
    }

    public static Integer[] wrap(int ... nArray) {
        if (null == nArray) {
            return null;
        }
        int n2 = nArray.length;
        if (0 == n2) {
            return new Integer[0];
        }
        Integer[] integerArray = new Integer[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            integerArray[i2] = nArray[i2];
        }
        return integerArray;
    }

    public static int[] unWrap(Integer ... integerArray) {
        if (null == integerArray) {
            return null;
        }
        int n2 = integerArray.length;
        if (0 == n2) {
            return new int[0];
        }
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = (Integer)ObjectUtil.defaultIfNull(integerArray[i2], 0);
        }
        return nArray;
    }

    public static Long[] wrap(long ... lArray) {
        if (null == lArray) {
            return null;
        }
        int n2 = lArray.length;
        if (0 == n2) {
            return new Long[0];
        }
        Long[] longArray = new Long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            longArray[i2] = lArray[i2];
        }
        return longArray;
    }

    public static long[] unWrap(Long ... longArray) {
        if (null == longArray) {
            return null;
        }
        int n2 = longArray.length;
        if (0 == n2) {
            return new long[0];
        }
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = (Long)ObjectUtil.defaultIfNull(longArray[i2], 0L);
        }
        return lArray;
    }

    public static Character[] wrap(char ... cArray) {
        if (null == cArray) {
            return null;
        }
        int n2 = cArray.length;
        if (0 == n2) {
            return new Character[0];
        }
        Character[] characterArray = new Character[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            characterArray[i2] = Character.valueOf(cArray[i2]);
        }
        return characterArray;
    }

    public static char[] unWrap(Character ... characterArray) {
        if (null == characterArray) {
            return null;
        }
        int n2 = characterArray.length;
        if (0 == n2) {
            return new char[0];
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = ((Character)ObjectUtil.defaultIfNull(characterArray[i2], Character.valueOf('\u0000'))).charValue();
        }
        return cArray;
    }

    public static Byte[] wrap(byte ... byArray) {
        if (null == byArray) {
            return null;
        }
        int n2 = byArray.length;
        if (0 == n2) {
            return new Byte[0];
        }
        Byte[] byteArray = new Byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byteArray[i2] = byArray[i2];
        }
        return byteArray;
    }

    public static byte[] unWrap(Byte ... byteArray) {
        if (null == byteArray) {
            return null;
        }
        int n2 = byteArray.length;
        if (0 == n2) {
            return new byte[0];
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (Byte)ObjectUtil.defaultIfNull(byteArray[i2], (byte)0);
        }
        return byArray;
    }

    public static Short[] wrap(short ... sArray) {
        if (null == sArray) {
            return null;
        }
        int n2 = sArray.length;
        if (0 == n2) {
            return new Short[0];
        }
        Short[] shortArray = new Short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            shortArray[i2] = sArray[i2];
        }
        return shortArray;
    }

    public static short[] unWrap(Short ... shortArray) {
        if (null == shortArray) {
            return null;
        }
        int n2 = shortArray.length;
        if (0 == n2) {
            return new short[0];
        }
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = (Short)ObjectUtil.defaultIfNull(shortArray[i2], (short)0);
        }
        return sArray;
    }

    public static Float[] wrap(float ... fArray) {
        if (null == fArray) {
            return null;
        }
        int n2 = fArray.length;
        if (0 == n2) {
            return new Float[0];
        }
        Float[] floatArray = new Float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            floatArray[i2] = Float.valueOf(fArray[i2]);
        }
        return floatArray;
    }

    public static float[] unWrap(Float ... floatArray) {
        if (null == floatArray) {
            return null;
        }
        int n2 = floatArray.length;
        if (0 == n2) {
            return new float[0];
        }
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = ((Float)ObjectUtil.defaultIfNull(floatArray[i2], Float.valueOf(0.0f))).floatValue();
        }
        return fArray;
    }

    public static Double[] wrap(double ... dArray) {
        if (null == dArray) {
            return null;
        }
        int n2 = dArray.length;
        if (0 == n2) {
            return new Double[0];
        }
        Double[] doubleArray = new Double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            doubleArray[i2] = dArray[i2];
        }
        return doubleArray;
    }

    public static double[] unWrap(Double ... doubleArray) {
        if (null == doubleArray) {
            return null;
        }
        int n2 = doubleArray.length;
        if (0 == n2) {
            return new double[0];
        }
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = (Double)ObjectUtil.defaultIfNull(doubleArray[i2], 0.0);
        }
        return dArray;
    }

    public static Boolean[] wrap(boolean ... blArray) {
        if (null == blArray) {
            return null;
        }
        int n2 = blArray.length;
        if (0 == n2) {
            return new Boolean[0];
        }
        Boolean[] booleanArray = new Boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            booleanArray[i2] = blArray[i2];
        }
        return booleanArray;
    }

    public static boolean[] unWrap(Boolean ... booleanArray) {
        if (null == booleanArray) {
            return null;
        }
        int n2 = booleanArray.length;
        if (0 == n2) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blArray[i2] = (Boolean)ObjectUtil.defaultIfNull(booleanArray[i2], false);
        }
        return blArray;
    }

    public static Object[] wrap(Object object) {
        if (null == object) {
            return null;
        }
        if (ArrayUtil.isArray(object)) {
            try {
                return (Object[])object;
            }
            catch (Exception exception) {
                String string;
                switch (string = object.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtil.wrap((long[])object);
                    }
                    case "int": {
                        return ArrayUtil.wrap((int[])object);
                    }
                    case "short": {
                        return ArrayUtil.wrap((short[])object);
                    }
                    case "char": {
                        return ArrayUtil.wrap((char[])object);
                    }
                    case "byte": {
                        return ArrayUtil.wrap((byte[])object);
                    }
                    case "boolean": {
                        return ArrayUtil.wrap((boolean[])object);
                    }
                    case "float": {
                        return ArrayUtil.wrap((float[])object);
                    }
                    case "double": {
                        return ArrayUtil.wrap((double[])object);
                    }
                }
                throw new UtilException(exception);
            }
        }
        throw new UtilException(StrUtil.format((CharSequence)"[{}] is not Array!", object.getClass()));
    }

    public static boolean isArray(Object object) {
        if (null == object) {
            return false;
        }
        return object.getClass().isArray();
    }

    public static Object get(Object object, int n2) {
        if (null == object) {
            return null;
        }
        if (n2 < 0) {
            n2 += Array.getLength(object);
        }
        try {
            return Array.get(object, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static Object[] getAny(Object object, int ... nArray) {
        if (null == object) {
            return null;
        }
        Object[] objectArray = ArrayUtil.newArray(object.getClass().getComponentType(), nArray.length);
        for (int n2 : nArray) {
            objectArray[n2] = ArrayUtil.get(object, n2);
        }
        return objectArray;
    }

    public static Object[] sub(Object[] objectArray, int n2, int n3) {
        int n4 = ArrayUtil.length(objectArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return ArrayUtil.newArray(objectArray.getClass().getComponentType(), 0);
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return ArrayUtil.newArray(objectArray.getClass().getComponentType(), 0);
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(objectArray, n2, n3);
    }

    public static byte[] sub(byte[] byArray, int n2, int n3) {
        int n4 = ArrayUtil.length(byArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new byte[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new byte[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(byArray, n2, n3);
    }

    public static int[] sub(int[] nArray, int n2, int n3) {
        int n4 = ArrayUtil.length(nArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new int[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new int[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(nArray, n2, n3);
    }

    public static long[] sub(long[] lArray, int n2, int n3) {
        int n4 = ArrayUtil.length(lArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new long[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new long[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(lArray, n2, n3);
    }

    public static short[] sub(short[] sArray, int n2, int n3) {
        int n4 = ArrayUtil.length(sArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new short[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new short[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(sArray, n2, n3);
    }

    public static char[] sub(char[] cArray, int n2, int n3) {
        int n4 = ArrayUtil.length(cArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new char[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new char[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(cArray, n2, n3);
    }

    public static double[] sub(double[] dArray, int n2, int n3) {
        int n4 = ArrayUtil.length(dArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new double[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new double[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(dArray, n2, n3);
    }

    public static float[] sub(float[] fArray, int n2, int n3) {
        int n4 = ArrayUtil.length(fArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new float[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new float[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(fArray, n2, n3);
    }

    public static boolean[] sub(boolean[] blArray, int n2, int n3) {
        int n4 = ArrayUtil.length(blArray);
        if (n2 < 0) {
            n2 += n4;
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == n4) {
            return new boolean[0];
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 > n4) {
            if (n2 >= n4) {
                return new boolean[0];
            }
            n3 = n4;
        }
        return Arrays.copyOfRange(blArray, n2, n3);
    }

    public static Object[] sub(Object object, int n2, int n3) {
        return ArrayUtil.sub(object, n2, n3, 1);
    }

    public static Object[] sub(Object object, int n2, int n3, int n4) {
        int n5 = ArrayUtil.length(object);
        if (n2 < 0) {
            n2 += n5;
        }
        if (n3 < 0) {
            n3 += n5;
        }
        if (n2 == n5) {
            return new Object[0];
        }
        if (n2 > n3) {
            int n6 = n2;
            n2 = n3;
            n3 = n6;
        }
        if (n3 > n5) {
            if (n2 >= n5) {
                return new Object[0];
            }
            n3 = n5;
        }
        if (n4 <= 1) {
            n4 = 1;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = n2; i2 < n3; i2 += n4) {
            arrayList.add(ArrayUtil.get(object, i2));
        }
        return arrayList.toArray();
    }

    public static String toString(Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (ArrayUtil.isArray(object)) {
            try {
                return Arrays.deepToString((Object[])object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object.toString();
    }

    public static int length(Object object) {
        if (null == object) {
            return 0;
        }
        return Array.getLength(object);
    }

    public static String join(Object[] objectArray, CharSequence charSequence) {
        return ArrayUtil.join(objectArray, charSequence, null, null);
    }

    public static String join(Object[] objectArray, CharSequence charSequence, String string, String string2) {
        if (null == objectArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Object object : objectArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            if (ArrayUtil.isArray(object)) {
                stringBuilder.append(ArrayUtil.join(ArrayUtil.wrap(object), charSequence, string, string2));
                continue;
            }
            if (object instanceof Iterable) {
                stringBuilder.append(CollUtil.join((Iterable)object, charSequence, string, string2));
                continue;
            }
            if (object instanceof Iterator) {
                stringBuilder.append(IterUtil.join((Iterator)object, charSequence, string, string2));
                continue;
            }
            stringBuilder.append(StrUtil.wrap(StrUtil.toString(object), string, string2));
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, CharSequence charSequence, Editor editor) {
        if (null == objectArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Object object : objectArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            if (null != editor) {
                object = editor.edit(object);
            }
            if (null == object) continue;
            stringBuilder.append(StrUtil.toString(object));
        }
        return stringBuilder.toString();
    }

    public static String join(long[] lArray, CharSequence charSequence) {
        if (null == lArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l2 : lArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(l2);
        }
        return stringBuilder.toString();
    }

    public static String join(int[] nArray, CharSequence charSequence) {
        if (null == nArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int n2 : nArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    public static String join(short[] sArray, CharSequence charSequence) {
        if (null == sArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (short s2 : sArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(s2);
        }
        return stringBuilder.toString();
    }

    public static String join(char[] cArray, CharSequence charSequence) {
        if (null == cArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (char c2 : cArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String join(byte[] byArray, CharSequence charSequence) {
        if (null == byArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (byte by : byArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(by);
        }
        return stringBuilder.toString();
    }

    public static String join(boolean[] blArray, CharSequence charSequence) {
        if (null == blArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (boolean bl2 : blArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(bl2);
        }
        return stringBuilder.toString();
    }

    public static String join(float[] fArray, CharSequence charSequence) {
        if (null == fArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (float f2 : fArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(f2);
        }
        return stringBuilder.toString();
    }

    public static String join(double[] dArray, CharSequence charSequence) {
        if (null == dArray) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (double d2 : dArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(d2);
        }
        return stringBuilder.toString();
    }

    public static String join(Object object, CharSequence charSequence) {
        if (ArrayUtil.isArray(object)) {
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz.isPrimitive()) {
                String string;
                switch (string = clazz.getName()) {
                    case "long": {
                        return ArrayUtil.join((long[])object, charSequence);
                    }
                    case "int": {
                        return ArrayUtil.join((int[])object, charSequence);
                    }
                    case "short": {
                        return ArrayUtil.join((short[])object, charSequence);
                    }
                    case "char": {
                        return ArrayUtil.join((char[])object, charSequence);
                    }
                    case "byte": {
                        return ArrayUtil.join((byte[])object, charSequence);
                    }
                    case "boolean": {
                        return ArrayUtil.join((boolean[])object, charSequence);
                    }
                    case "float": {
                        return ArrayUtil.join((float[])object, charSequence);
                    }
                    case "double": {
                        return ArrayUtil.join((double[])object, charSequence);
                    }
                }
                throw new UtilException("Unknown primitive type: [{}]", string);
            }
            return ArrayUtil.join((Object[])object, charSequence);
        }
        throw new UtilException(StrUtil.format((CharSequence)"[{}] is not a Array!", object.getClass()));
    }

    public static byte[] toArray(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasArray()) {
            int n2 = byteBuffer.position();
            byteBuffer.position(0);
            int n3 = byteBuffer.limit();
            byte[] byArray = new byte[n3];
            byteBuffer.get(byArray);
            byteBuffer.position(n2);
            return byArray;
        }
        return Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
    }

    public static Object[] toArray(Iterator iterator, Class clazz) {
        return ArrayUtil.toArray(CollUtil.newArrayList(iterator), clazz);
    }

    public static Object[] toArray(Iterable iterable, Class clazz) {
        return ArrayUtil.toArray(CollectionUtil.toCollection(iterable), clazz);
    }

    public static Object[] toArray(Collection collection, Class clazz) {
        return collection.toArray(ArrayUtil.newArray(clazz, 0));
    }

    public static Object[] remove(Object[] objectArray, int n2) {
        return (Object[])ArrayUtil.remove((Object)objectArray, n2);
    }

    public static long[] remove(long[] lArray, int n2) {
        return (long[])ArrayUtil.remove((Object)lArray, n2);
    }

    public static int[] remove(int[] nArray, int n2) {
        return (int[])ArrayUtil.remove((Object)nArray, n2);
    }

    public static short[] remove(short[] sArray, int n2) {
        return (short[])ArrayUtil.remove((Object)sArray, n2);
    }

    public static char[] remove(char[] cArray, int n2) {
        return (char[])ArrayUtil.remove((Object)cArray, n2);
    }

    public static byte[] remove(byte[] byArray, int n2) {
        return (byte[])ArrayUtil.remove((Object)byArray, n2);
    }

    public static double[] remove(double[] dArray, int n2) {
        return (double[])ArrayUtil.remove((Object)dArray, n2);
    }

    public static float[] remove(float[] fArray, int n2) {
        return (float[])ArrayUtil.remove((Object)fArray, n2);
    }

    public static boolean[] remove(boolean[] blArray, int n2) {
        return (boolean[])ArrayUtil.remove((Object)blArray, n2);
    }

    public static Object remove(Object object, int n2) {
        if (null == object) {
            return null;
        }
        int n3 = ArrayUtil.length(object);
        if (n2 < 0 || n2 >= n3) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n3 - 1);
        System.arraycopy(object, 0, object2, 0, n2);
        if (n2 < n3 - 1) {
            System.arraycopy(object, n2 + 1, object2, n2, n3 - n2 - 1);
        }
        return object2;
    }

    public static Object[] removeEle(Object[] objectArray, Object object) {
        return ArrayUtil.remove(objectArray, ArrayUtil.indexOf(objectArray, object));
    }

    public static long[] removeEle(long[] lArray, long l2) {
        return ArrayUtil.remove(lArray, ArrayUtil.indexOf(lArray, l2));
    }

    public static int[] removeEle(int[] nArray, int n2) {
        return ArrayUtil.remove(nArray, ArrayUtil.indexOf(nArray, n2));
    }

    public static short[] removeEle(short[] sArray, short s2) {
        return ArrayUtil.remove(sArray, ArrayUtil.indexOf(sArray, s2));
    }

    public static char[] removeEle(char[] cArray, char c2) {
        return ArrayUtil.remove(cArray, ArrayUtil.indexOf(cArray, c2));
    }

    public static byte[] removeEle(byte[] byArray, byte by) {
        return ArrayUtil.remove(byArray, ArrayUtil.indexOf(byArray, by));
    }

    public static double[] removeEle(double[] dArray, double d2) {
        return ArrayUtil.remove(dArray, ArrayUtil.indexOf(dArray, d2));
    }

    public static float[] removeEle(float[] fArray, float f2) {
        return ArrayUtil.remove(fArray, ArrayUtil.indexOf(fArray, f2));
    }

    public static boolean[] removeEle(boolean[] blArray, boolean bl) {
        return ArrayUtil.remove(blArray, ArrayUtil.indexOf(blArray, bl));
    }

    public static Object[] reverse(Object[] objectArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(objectArray)) {
            return objectArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(objectArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n4];
            objectArray[n4] = object;
        }
        return objectArray;
    }

    public static Object[] reverse(Object[] objectArray) {
        return ArrayUtil.reverse(objectArray, 0, objectArray.length);
    }

    public static long[] reverse(long[] lArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(lArray)) {
            return lArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(lArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            long l2 = lArray[i2];
            lArray[i2] = lArray[n4];
            lArray[n4] = l2;
        }
        return lArray;
    }

    public static long[] reverse(long[] lArray) {
        return ArrayUtil.reverse(lArray, 0, lArray.length);
    }

    public static int[] reverse(int[] nArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(nArray)) {
            return nArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(nArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            int n5 = nArray[i2];
            nArray[i2] = nArray[n4];
            nArray[n4] = n5;
        }
        return nArray;
    }

    public static int[] reverse(int[] nArray) {
        return ArrayUtil.reverse(nArray, 0, nArray.length);
    }

    public static short[] reverse(short[] sArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(sArray)) {
            return sArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(sArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            short s2 = sArray[i2];
            sArray[i2] = sArray[n4];
            sArray[n4] = s2;
        }
        return sArray;
    }

    public static short[] reverse(short[] sArray) {
        return ArrayUtil.reverse(sArray, 0, sArray.length);
    }

    public static char[] reverse(char[] cArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(cArray)) {
            return cArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(cArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            char c2 = cArray[i2];
            cArray[i2] = cArray[n4];
            cArray[n4] = c2;
        }
        return cArray;
    }

    public static char[] reverse(char[] cArray) {
        return ArrayUtil.reverse(cArray, 0, cArray.length);
    }

    public static byte[] reverse(byte[] byArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(byArray)) {
            return byArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(byArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            byte by = byArray[i2];
            byArray[i2] = byArray[n4];
            byArray[n4] = by;
        }
        return byArray;
    }

    public static byte[] reverse(byte[] byArray) {
        return ArrayUtil.reverse(byArray, 0, byArray.length);
    }

    public static double[] reverse(double[] dArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(dArray)) {
            return dArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(dArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            double d2 = dArray[i2];
            dArray[i2] = dArray[n4];
            dArray[n4] = d2;
        }
        return dArray;
    }

    public static double[] reverse(double[] dArray) {
        return ArrayUtil.reverse(dArray, 0, dArray.length);
    }

    public static float[] reverse(float[] fArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(fArray)) {
            return fArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(fArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            float f2 = fArray[i2];
            fArray[i2] = fArray[n4];
            fArray[n4] = f2;
        }
        return fArray;
    }

    public static float[] reverse(float[] fArray) {
        return ArrayUtil.reverse(fArray, 0, fArray.length);
    }

    public static boolean[] reverse(boolean[] blArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(blArray)) {
            return blArray;
        }
        int n4 = Math.max(n2, 0);
        for (int i2 = Math.min(blArray.length, n3) - 1; i2 > n4; --i2, ++n4) {
            boolean bl = blArray[i2];
            blArray[i2] = blArray[n4];
            blArray[n4] = bl;
        }
        return blArray;
    }

    public static boolean[] reverse(boolean[] blArray) {
        return ArrayUtil.reverse(blArray, 0, blArray.length);
    }

    public static Comparable min(Comparable[] comparableArray) {
        return ArrayUtil.min(comparableArray, null);
    }

    public static Comparable min(Comparable[] comparableArray, Comparator comparator) {
        if (ArrayUtil.isEmpty(comparableArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        Comparable comparable = comparableArray[0];
        for (Comparable comparable2 : comparableArray) {
            if (CompareUtil.compare((Object)comparable, (Object)comparable2, comparator) <= 0) continue;
            comparable = comparable2;
        }
        return comparable;
    }

    public static long min(long ... lArray) {
        if (ArrayUtil.isEmpty(lArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (l2 <= lArray[i2]) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static int min(int ... nArray) {
        if (ArrayUtil.isEmpty(nArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (n2 <= nArray[i2]) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static short min(short ... sArray) {
        if (ArrayUtil.isEmpty(sArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (s2 <= sArray[i2]) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static char min(char ... cArray) {
        if (ArrayUtil.isEmpty(cArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char c2 = cArray[0];
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            if (c2 <= cArray[i2]) continue;
            c2 = cArray[i2];
        }
        return c2;
    }

    public static byte min(byte ... byArray) {
        if (ArrayUtil.isEmpty(byArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte by = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (by <= byArray[i2]) continue;
            by = byArray[i2];
        }
        return by;
    }

    public static double min(double ... dArray) {
        if (ArrayUtil.isEmpty(dArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (!(d2 > dArray[i2])) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static float min(float ... fArray) {
        if (ArrayUtil.isEmpty(fArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (!(f2 > fArray[i2])) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static Comparable max(Comparable[] comparableArray) {
        return ArrayUtil.max(comparableArray, null);
    }

    public static Comparable max(Comparable[] comparableArray, Comparator comparator) {
        if (ArrayUtil.isEmpty(comparableArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        Comparable comparable = comparableArray[0];
        for (int i2 = 1; i2 < comparableArray.length; ++i2) {
            if (CompareUtil.compare((Object)comparable, (Object)comparableArray[i2], comparator) >= 0) continue;
            comparable = comparableArray[i2];
        }
        return comparable;
    }

    public static long max(long ... lArray) {
        if (ArrayUtil.isEmpty(lArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (l2 >= lArray[i2]) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static int max(int ... nArray) {
        if (ArrayUtil.isEmpty(nArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (n2 >= nArray[i2]) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static short max(short ... sArray) {
        if (ArrayUtil.isEmpty(sArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (s2 >= sArray[i2]) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static char max(char ... cArray) {
        if (ArrayUtil.isEmpty(cArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char c2 = cArray[0];
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            if (c2 >= cArray[i2]) continue;
            c2 = cArray[i2];
        }
        return c2;
    }

    public static byte max(byte ... byArray) {
        if (ArrayUtil.isEmpty(byArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte by = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (by >= byArray[i2]) continue;
            by = byArray[i2];
        }
        return by;
    }

    public static double max(double ... dArray) {
        if (ArrayUtil.isEmpty(dArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (!(d2 < dArray[i2])) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static float max(float ... fArray) {
        if (ArrayUtil.isEmpty(fArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (!(f2 < fArray[i2])) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static int[] swap(int[] nArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(nArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int n4 = nArray[n2];
        nArray[n2] = nArray[n3];
        nArray[n3] = n4;
        return nArray;
    }

    public static long[] swap(long[] lArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(lArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long l2 = lArray[n2];
        lArray[n2] = lArray[n3];
        lArray[n3] = l2;
        return lArray;
    }

    public static double[] swap(double[] dArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(dArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double d2 = dArray[n2];
        dArray[n2] = dArray[n3];
        dArray[n3] = d2;
        return dArray;
    }

    public static float[] swap(float[] fArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(fArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float f2 = fArray[n2];
        fArray[n2] = fArray[n3];
        fArray[n3] = f2;
        return fArray;
    }

    public static boolean[] swap(boolean[] blArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(blArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        boolean bl = blArray[n2];
        blArray[n2] = blArray[n3];
        blArray[n3] = bl;
        return blArray;
    }

    public static byte[] swap(byte[] byArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(byArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte by = byArray[n2];
        byArray[n2] = byArray[n3];
        byArray[n3] = by;
        return byArray;
    }

    public static char[] swap(char[] cArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(cArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char c2 = cArray[n2];
        cArray[n2] = cArray[n3];
        cArray[n3] = c2;
        return cArray;
    }

    public static short[] swap(short[] sArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(sArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short s2 = sArray[n2];
        sArray[n2] = sArray[n3];
        sArray[n3] = s2;
        return sArray;
    }

    public static Object[] swap(Object[] objectArray, int n2, int n3) {
        if (ArrayUtil.isEmpty(objectArray)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
        return objectArray;
    }

    public static Object swap(Object object, int n2, int n3) {
        if (ArrayUtil.isEmpty(object)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object object2 = ArrayUtil.get(object, n2);
        Array.set(object, n2, Array.get(object, n3));
        Array.set(object, n3, object2);
        return object;
    }

    public static int emptyCount(Object ... objectArray) {
        int n2 = 0;
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!ObjectUtil.isEmpty(object)) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static boolean hasEmpty(Object ... objectArray) {
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!ObjectUtil.isEmpty(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... objectArray) {
        return ArrayUtil.emptyCount(objectArray) == objectArray.length;
    }

    public static boolean isAllNotEmpty(Object ... objectArray) {
        return false == ArrayUtil.hasEmpty(objectArray);
    }

    public static Object[] distinct(Object[] objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            return objectArray;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(objectArray.length, 1.0f);
        Collections.addAll(linkedHashSet, objectArray);
        return ArrayUtil.toArray(linkedHashSet, ArrayUtil.getComponentType(objectArray));
    }

    public static boolean isAllNotNull(Object ... objectArray) {
        return false == ArrayUtil.hasNull(objectArray);
    }

    public static Object[] map(Object[] objectArray, Class clazz, Function function) {
        Object[] objectArray2 = ArrayUtil.newArray(clazz, objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = function.apply(objectArray[i2]);
        }
        return objectArray2;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (ArrayUtil.hasNull(object, object2)) {
            return false;
        }
        Assert.isTrue(ArrayUtil.isArray(object), "First is not a Array !", new Object[0]);
        Assert.isTrue(ArrayUtil.isArray(object2), "Second is not a Array !", new Object[0]);
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        if (object instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        if (object instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return Arrays.deepEquals((Object[])object, (Object[])object2);
    }
}

