/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.thread;

import com.ccb.core.thread.ConcurrencyTester;
import com.ccb.core.thread.ExecutorBuilder;
import com.ccb.core.thread.GlobalThreadPool;
import com.ccb.core.thread.NamedThreadFactory;
import com.ccb.core.thread.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    public static ExecutorService newExecutor(int n2) {
        ExecutorBuilder executorBuilder = ExecutorBuilder.create();
        if (n2 > 0) {
            executorBuilder.setCorePoolSize(n2);
        }
        return executorBuilder.build();
    }

    public static ExecutorService newExecutor() {
        return ExecutorBuilder.create().useSynchronousQueue().build();
    }

    public static ExecutorService newSingleExecutor() {
        return ExecutorBuilder.create().setCorePoolSize(1).setMaxPoolSize(1).setKeepAliveTime(0L).buildFinalizable();
    }

    public static ThreadPoolExecutor newExecutor(int n2, int n3) {
        return ExecutorBuilder.create().setCorePoolSize(n2).setMaxPoolSize(n3).build();
    }

    public static ExecutorService newExecutor(int n2, int n3, int n4) {
        return ExecutorBuilder.create().setCorePoolSize(n2).setMaxPoolSize(n3).setWorkQueue(new LinkedBlockingQueue(n4)).build();
    }

    public static ThreadPoolExecutor newExecutorByBlockingCoefficient(float f2) {
        if (f2 >= 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("[blockingCoefficient] must between 0 and 1, or equals 0.");
        }
        int n2 = (int)((float)Runtime.getRuntime().availableProcessors() / (1.0f - f2));
        return ExecutorBuilder.create().setCorePoolSize(n2).setMaxPoolSize(n2).setKeepAliveTime(0L).build();
    }

    public static void execute(Runnable runnable) {
        GlobalThreadPool.execute(runnable);
    }

    public static Runnable execAsync(Runnable runnable, boolean bl) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(bl);
        thread.start();
        return runnable;
    }

    public static Future execAsync(Callable callable) {
        return GlobalThreadPool.submit(callable);
    }

    public static Future execAsync(Runnable runnable) {
        return GlobalThreadPool.submit(runnable);
    }

    public static CompletionService newCompletionService() {
        return new ExecutorCompletionService(GlobalThreadPool.getExecutor());
    }

    public static CompletionService newCompletionService(ExecutorService executorService) {
        return new ExecutorCompletionService(executorService);
    }

    public static CountDownLatch newCountDownLatch(int n2) {
        return new CountDownLatch(n2);
    }

    public static Thread newThread(Runnable runnable, String string) {
        Thread thread = ThreadUtil.newThread(runnable, string, false);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }

    public static Thread newThread(Runnable runnable, String string, boolean bl) {
        Thread thread = new Thread(null, runnable, string);
        thread.setDaemon(bl);
        return thread;
    }

    public static boolean sleep(Number number, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(number.longValue());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static boolean sleep(Number number) {
        if (number == null) {
            return true;
        }
        return ThreadUtil.sleep(number.longValue());
    }

    public static boolean sleep(long l2) {
        if (l2 > 0L) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public static boolean safeSleep(Number number) {
        if (number == null) {
            return true;
        }
        return ThreadUtil.safeSleep(number.longValue());
    }

    public static boolean safeSleep(long l2) {
        long l3;
        for (long i2 = 0L; i2 >= 0L && i2 < l2; i2 += l3) {
            long l4 = System.currentTimeMillis();
            if (!ThreadUtil.sleep(l2 - i2)) {
                return false;
            }
            l3 = System.currentTimeMillis() - l4;
            if (l3 <= 0L) break;
        }
        return true;
    }

    public static StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackTraceElement(int n2) {
        StackTraceElement[] stackTraceElementArray = ThreadUtil.getStackTrace();
        if (n2 < 0) {
            n2 += stackTraceElementArray.length;
        }
        return stackTraceElementArray[n2];
    }

    public static ThreadLocal createThreadLocal(boolean bl) {
        if (bl) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    }

    public static ThreadFactoryBuilder createThreadFactoryBuilder() {
        return ThreadFactoryBuilder.create();
    }

    public static void interrupt(Thread thread, boolean bl) {
        if (null != thread && !thread.isInterrupted()) {
            thread.interrupt();
            if (bl) {
                ThreadUtil.waitForDie(thread);
            }
        }
    }

    public static void waitForDie() {
        ThreadUtil.waitForDie(Thread.currentThread());
    }

    public static void waitForDie(Thread thread) {
        if (null == thread) {
            return;
        }
        boolean bl = false;
        do {
            try {
                thread.join();
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!bl);
    }

    public static Thread[] getThreads() {
        return ThreadUtil.getThreads(Thread.currentThread().getThreadGroup().getParent());
    }

    public static Thread[] getThreads(ThreadGroup threadGroup) {
        Thread[] threadArray = new Thread[threadGroup.activeCount() * 2];
        int n2 = threadGroup.enumerate(threadArray);
        Thread[] threadArray2 = new Thread[n2];
        System.arraycopy(threadArray, 0, threadArray2, 0, n2);
        return threadArray2;
    }

    public static Thread getMainThread() {
        for (Thread thread : ThreadUtil.getThreads()) {
            if (thread.getId() != 1L) continue;
            return thread;
        }
        return null;
    }

    public static ThreadGroup currentThreadGroup() {
        SecurityManager securityManager = System.getSecurityManager();
        return null != securityManager ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public static ThreadFactory newNamedThreadFactory(String string, boolean bl) {
        return new NamedThreadFactory(string, bl);
    }

    public static ThreadFactory newNamedThreadFactory(String string, ThreadGroup threadGroup, boolean bl) {
        return new NamedThreadFactory(string, threadGroup, bl);
    }

    public static ThreadFactory newNamedThreadFactory(String string, ThreadGroup threadGroup, boolean bl, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        return new NamedThreadFactory(string, threadGroup, bl, uncaughtExceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync(Object object) {
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static ConcurrencyTester concurrencyTest(int n2, Runnable runnable) {
        return new ConcurrencyTester(n2).test(runnable);
    }
}

